/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.Objects;
import java.util.Set;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.setup.InstallationResources;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public abstract class InstallationScriptProvider
extends InstallationResources {
    @Deprecated(since="1.5", forRemoval=true)
    protected static final String PREPARE = "Prepare";
    @Deprecated(since="1.5", forRemoval=true)
    protected static final String FINISH = "Finish";
    private final Set<String> authorities;
    private final String[] resources;

    protected InstallationScriptProvider(String authority, String ... resources) {
        this.resources = Objects.requireNonNull(resources);
        this.authorities = authority != null ? Set.of(authority) : Set.of();
    }

    public Set<String> getAuthorities() {
        return this.authorities;
    }

    private void verifyAuthority(String authority) {
        if (!this.authorities.contains(authority)) {
            throw new IllegalArgumentException(Errors.format((short)59, (Object)"authority", (Object)authority));
        }
    }

    public String[] getResourceNames(String authority) throws IOException {
        this.verifyAuthority(authority);
        return (String[])this.resources.clone();
    }

    public BufferedReader openScript(String authority, int resource) throws IOException {
        this.verifyAuthority(authority);
        if (!"EPSG".equals(authority)) {
            throw new IllegalStateException(Resources.format((short)66, authority));
        }
        String name = this.resources[resource];
        NoSuchFileException cause = null;
        try {
            InputStream in = this.openStream(name);
            if (in != null) {
                return new LineNumberReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            }
        }
        catch (NoSuchFileException e) {
            cause = e;
        }
        FileNotFoundException e = new FileNotFoundException(Errors.format((short)52, (Object)name));
        e.initCause(cause);
        throw e;
    }

    protected abstract InputStream openStream(String var1) throws IOException;

    static void log(LogRecord record) {
        Logging.completeAndLog((Logger)EPSGDataAccess.LOGGER, EPSGFactory.class, (String)"install", (LogRecord)record);
    }
}

