/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.RangeQuery;

public final class RangeQueryBuilder
implements QueryBuilder {
    private final String name;
    private Object gte;
    private Object gt;
    private Object lte;
    private Object lt;
    private Double boost;

    RangeQueryBuilder(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be null or empty");
        this.name = name;
    }

    public RangeQueryBuilder gte(Object gte) {
        this.gte = Objects.requireNonNull(gte, "gte");
        return this;
    }

    public RangeQueryBuilder gt(Object gt) {
        this.gt = Objects.requireNonNull(gt, "gt");
        return this;
    }

    public RangeQueryBuilder lte(Object lte) {
        this.lte = Objects.requireNonNull(lte, "lte");
        return this;
    }

    public RangeQueryBuilder lt(Object lt) {
        this.lt = Objects.requireNonNull(lt, "lt");
        return this;
    }

    public RangeQueryBuilder boost(Double boost) {
        Objects.requireNonNull(boost, "boost");
        this.boost = boost;
        return this;
    }

    @Override
    public Query build() {
        return new RangeQuery(this.name, this.gte, this.gt, this.lte, this.lt, this.boost);
    }
}

