/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class SparseMatrix$
implements Serializable {
    public static final SparseMatrix$ MODULE$ = new SparseMatrix$();

    public Option<Tuple6<Object, Object, int[], int[], double[], Object>> unapply(SparseMatrix sm) {
        return new Some((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)sm.numRows()), (Object)BoxesRunTime.boxToInteger((int)sm.numCols()), (Object)sm.colPtrs(), (Object)sm.rowIndices(), (Object)sm.values(), (Object)BoxesRunTime.boxToBoolean((boolean)sm.isTransposed())));
    }

    public SparseMatrix fromVectors(Seq<Vector> vectors) {
        int numRows = vectors.length();
        int numCols = ((Vector)vectors.head()).size();
        ArrayBuilder colIndices = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
        ArrayBuilder values = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        ArrayBuilder rowPtrs = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
        int rowPtr = 0;
        rowPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        for (int j = 0; j < numRows; ++j) {
            IntRef nnz = IntRef.create((int)0);
            ((Vector)vectors.apply(j)).foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable)(i, v) -> {
                colIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                values.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                ++nnz$1.elem;
            });
            rowPtrs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(rowPtr += nnz.elem)));
        }
        return new SparseMatrix(numRows, numCols, (int[])rowPtrs.result(), (int[])colIndices.result(), (double[])values.result(), true);
    }

    public SparseMatrix fromCOO(int numRows, int numCols, Iterable<Tuple3<Object, Object, Object>> entries) {
        Seq sortedEntries = (Seq)entries.toSeq().sortBy((Function1 & Serializable)v -> new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)v._2()), BoxesRunTime.unboxToInt((Object)v._1())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        int numEntries = sortedEntries.size();
        if (sortedEntries.nonEmpty()) {
            package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)((Tuple3)sortedEntries.head())._2()), BoxesRunTime.unboxToInt((Object)((Tuple3)sortedEntries.last())._2())})).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> Predef$.MODULE$.require(col >= 0 && col < numCols, (Function0 & Serializable)() -> "Column index out of range [0, " + numCols + "): " + col + "."));
        }
        int[] colPtrs = new int[numCols + 1];
        ArrayBuilder rowIndices = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
        rowIndices.sizeHint(numEntries);
        ArrayBuilder values = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        values.sizeHint(numEntries);
        IntRef nnz = IntRef.create((int)0);
        IntRef prevCol = IntRef.create((int)0);
        IntRef prevRow = IntRef.create((int)-1);
        DoubleRef prevVal = DoubleRef.create((double)0.0);
        ((IterableOnceOps)sortedEntries.view().$colon$plus((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)numRows), (Object)BoxesRunTime.boxToInteger((int)numCols), (Object)BoxesRunTime.boxToDouble((double)1.0)))).foreach((Function1 & Serializable)x0$1 -> {
            SparseMatrix$.$anonfun$fromCOO$4(prevRow, prevCol, prevVal, numRows, nnz, rowIndices, values, colPtrs, x0$1);
            return BoxedUnit.UNIT;
        });
        return new SparseMatrix(numRows, numCols, colPtrs, (int[])rowIndices.result(), (double[])values.result());
    }

    public SparseMatrix speye(int n) {
        return new SparseMatrix(n, n, (int[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), n).toArray((ClassTag)ClassTag$.MODULE$.Int()), (int[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).toArray((ClassTag)ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double()));
    }

    private SparseMatrix genRandMatrix(int numRows, int numCols, double density, Random rng) {
        Predef$.MODULE$.require(numRows > 0, (Function0 & Serializable)() -> "numRows must be greater than 0 but got " + numRows);
        Predef$.MODULE$.require(numCols > 0, (Function0 & Serializable)() -> "numCols must be greater than 0 but got " + numCols);
        Predef$.MODULE$.require(density >= 0.0 && density <= 1.0, (Function0 & Serializable)() -> "density must be a double in the range 0.0 <= d <= 1.0. Currently, density: " + density);
        long size = (long)numRows * (long)numCols;
        double expected = (double)size * density;
        Predef$.MODULE$.assert(expected < (double)Integer.MAX_VALUE, (Function0 & Serializable)() -> "The expected number of nonzeros cannot be greater than Int.MaxValue.");
        int nnz = (int)scala.math.package$.MODULE$.ceil(expected);
        if (density == 0.0) {
            return new SparseMatrix(numRows, numCols, new int[numCols + 1], (int[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()));
        }
        if (density == 1.0) {
            int[] colPtrs = (int[])Array$.MODULE$.tabulate(numCols + 1, (Function1)(JFunction1.mcII.sp & Serializable)j -> j * numRows, (ClassTag)ClassTag$.MODULE$.Int());
            int[] rowIndices = (int[])Array$.MODULE$.tabulate((int)size, (Function1)(JFunction1.mcII.sp & Serializable)idx -> idx % numRows, (ClassTag)ClassTag$.MODULE$.Int());
            return new SparseMatrix(numRows, numCols, colPtrs, rowIndices, new double[numRows * numCols]);
        }
        if (density < 0.34) {
            HashSet entries = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (entries.size() < nnz) {
                entries.$plus$eq((Object)new Tuple2.mcII.sp(rng.nextInt(numRows), rng.nextInt(numCols)));
            }
            return this.fromCOO(numRows, numCols, (Iterable<Tuple3<Object, Object, Object>>)((Iterable)entries.map((Function1 & Serializable)v -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)1.0)))));
        }
        long idx2 = 0L;
        int numSelected = 0;
        int[] colPtrs = new int[numCols + 1];
        int[] rowIndices = new int[nnz];
        for (int j2 = 0; j2 < numCols && numSelected < nnz; ++j2) {
            int i = 0;
            while (i < numRows && numSelected < nnz) {
                if (rng.nextDouble() < 1.0 * (double)(nnz - numSelected) / (double)(size - idx2)) {
                    rowIndices[numSelected] = i;
                    ++numSelected;
                }
                ++i;
                ++idx2;
            }
            colPtrs[j2 + 1] = numSelected;
        }
        return new SparseMatrix(numRows, numCols, colPtrs, rowIndices, new double[nnz]);
    }

    public SparseMatrix sprand(int numRows, int numCols, double density, Random rng) {
        SparseMatrix mat = this.genRandMatrix(numRows, numCols, density, rng);
        return mat.update((Function1)(JFunction1.mcDD.sp & Serializable)i -> rng.nextDouble());
    }

    public SparseMatrix sprandn(int numRows, int numCols, double density, Random rng) {
        SparseMatrix mat = this.genRandMatrix(numRows, numCols, density, rng);
        return mat.update((Function1)(JFunction1.mcDD.sp & Serializable)i -> rng.nextGaussian());
    }

    public SparseMatrix spdiag(Vector vector) {
        int n = vector.size();
        Vector vector2 = vector;
        if (vector2 instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector2;
            return this.fromCOO(n, n, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.intArrayOps(sparseVector.indices()), (IterableOnce)Predef$.MODULE$.wrapDoubleArray(sparseVector.values()))), (Function1 & Serializable)v -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)v._2$mcD$sp())), ClassTag$.MODULE$.apply(Tuple3.class))));
        }
        if (vector2 instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector2;
            Tuple2[] entries = ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.doubleArrayOps(denseVector.values()));
            Tuple2[] nnzVals = (Tuple2[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])entries), (Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)SparseMatrix$.$anonfun$spdiag$2(v)));
            return this.fromCOO(n, n, (Iterable<Tuple3<Object, Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])nnzVals), (Function1 & Serializable)v -> new Tuple3((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)v._1$mcD$sp())), ClassTag$.MODULE$.apply(Tuple3.class))));
        }
        throw new MatchError((Object)vector2);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SparseMatrix$.class);
    }

    public static final /* synthetic */ void $anonfun$fromCOO$4(IntRef prevRow$1, IntRef prevCol$1, DoubleRef prevVal$1, int numRows$5, IntRef nnz$2, ArrayBuilder rowIndices$1, ArrayBuilder values$3, int[] colPtrs$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            if (v != 0.0) {
                if (i == prevRow$1.elem && j == prevCol$1.elem) {
                    prevVal$1.elem += v;
                    return;
                }
                if (prevVal$1.elem != 0.0) {
                    Predef$.MODULE$.require(prevRow$1.elem >= 0 && prevRow$1.elem < numRows$5, (Function0 & Serializable)() -> "Row index out of range [0, " + numRows$5 + "): " + prevRow$1.elem + ".");
                    ++nnz$2.elem;
                    rowIndices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)prevRow$1.elem));
                    v0 = values$3.$plus$eq((Object)BoxesRunTime.boxToDouble((double)prevVal$1.elem));
                } else {
                    v0 = BoxedUnit.UNIT;
                }
                prevRow$1.elem = i;
                prevVal$1.elem = v;
                while (prevCol$1.elem < j) {
                    colPtrs$1[prevCol$1.elem + 1] = nnz$2.elem;
                    ++prevCol$1.elem;
                }
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ boolean $anonfun$spdiag$2(Tuple2 v) {
        return v._1$mcD$sp() != 0.0;
    }

    private SparseMatrix$() {
    }
}

