/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

@Description(name="internal_interval", value="_FUNC_(intervalType,intervalArg)", extended="this method is not designed to be used by directly calling it - it provides internal support for 'INTERVAL (intervalArg) intervalType' constructs")
public class GenericUDFInternalInterval
extends GenericUDF {
    private Map<Integer, IntervalProcessor> processorMap;
    private transient IntervalProcessor processor;
    private transient PrimitiveObjectInspector inputOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (!(arguments[0] instanceof ConstantObjectInspector)) {
            throw new UDFArgumentTypeException(0, this.getFuncName() + ": may only accept constant as first argument");
        }
        Integer operationMode = this.getConstantIntValue(arguments, 0);
        if (operationMode == null) {
            throw new UDFArgumentTypeException(0, "must supply operationmode");
        }
        this.processor = this.getProcessorMap().get(operationMode);
        if (this.processor == null) {
            throw new UDFArgumentTypeException(0, this.getFuncName() + ": unsupported operationMode: " + operationMode);
        }
        if (arguments[1].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(1, "The first argument to " + this.getFuncName() + " must be primitive");
        }
        this.inputOI = (PrimitiveObjectInspector)arguments[1];
        PrimitiveObjectInspector.PrimitiveCategory inputCategory = this.inputOI.getPrimitiveCategory();
        if (!this.isValidInputCategory(inputCategory)) {
            throw new UDFArgumentTypeException(1, "The second argument to " + this.getFuncName() + " must be from the string group or numeric group (except:float/double)");
        }
        if (arguments[1] instanceof ConstantObjectInspector) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)this.processor.getTypeInfo(), (Object)this.processor.evaluate(this.getConstantStringValue(arguments, 1)));
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)this.processor.getTypeInfo());
    }

    private boolean isValidInputCategory(PrimitiveObjectInspector.PrimitiveCategory cat) throws UDFArgumentTypeException {
        PrimitiveObjectInspectorUtils.PrimitiveGrouping inputOIGroup = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)cat);
        if (inputOIGroup == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return true;
        }
        if (inputOIGroup == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP) {
            switch (cat) {
                case DOUBLE: 
                case FLOAT: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String argString = PrimitiveObjectInspectorUtils.getString((Object)arguments[1].get(), (PrimitiveObjectInspector)this.inputOI);
        if (argString == null) {
            return null;
        }
        try {
            return this.processor.evaluate(argString);
        }
        catch (Exception e) {
            throw new UDFArgumentTypeException(1, "Error parsing interval " + argString + " using:" + this.processor.getClass().getSimpleName());
        }
    }

    private Map<Integer, IntervalProcessor> getProcessorMap() {
        IntervalProcessor[] ips;
        if (this.processorMap != null) {
            return this.processorMap;
        }
        HashMap<Integer, IntervalProcessor> ret = new HashMap<Integer, IntervalProcessor>();
        for (IntervalProcessor ip : ips = new IntervalProcessor[]{new IntervalDayTimeLiteralProcessor(), new IntervalDayLiteralProcessor(), new IntervalHourLiteralProcessor(), new IntervalMinuteLiteralProcessor(), new IntervalSecondLiteralProcessor(), new IntervalYearMonthLiteralProcessor(), new IntervalYearLiteralProcessor(), new IntervalMonthLiteralProcessor()}) {
            ret.put(ip.getKey(), ip);
        }
        this.processorMap = ret;
        return this.processorMap;
    }

    @Override
    public String getDisplayString(String[] children) {
        return String.format("%s(%s)", this.processor.getClass().getSimpleName(), children[1]);
    }

    private static class IntervalMonthLiteralProcessor
    extends AbstractYearMonthIntervalProcessor {
        private IntervalMonthLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 792;
        }

        @Override
        protected HiveIntervalYearMonth getIntervalYearMonth(String arg) {
            return new HiveIntervalYearMonth(0, Integer.parseInt(arg));
        }
    }

    private static class IntervalYearLiteralProcessor
    extends AbstractYearMonthIntervalProcessor {
        private IntervalYearLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 794;
        }

        @Override
        protected HiveIntervalYearMonth getIntervalYearMonth(String arg) {
            return new HiveIntervalYearMonth(Integer.parseInt(arg), 0);
        }
    }

    private static class IntervalYearMonthLiteralProcessor
    extends AbstractYearMonthIntervalProcessor {
        private IntervalYearMonthLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 796;
        }

        @Override
        protected HiveIntervalYearMonth getIntervalYearMonth(String arg) {
            return HiveIntervalYearMonth.valueOf((String)arg);
        }
    }

    private static class IntervalDayTimeLiteralProcessor
    extends AbstractDayTimeIntervalProcessor {
        private IntervalDayTimeLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 789;
        }

        @Override
        protected HiveIntervalDayTime getIntervalDayTime(String arg) {
            return HiveIntervalDayTime.valueOf((String)arg);
        }
    }

    private static class IntervalSecondLiteralProcessor
    extends AbstractDayTimeIntervalProcessor {
        private static final BigDecimal NANOS_PER_SEC_BD = new BigDecimal(1000000000);

        private IntervalSecondLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 793;
        }

        @Override
        protected HiveIntervalDayTime getIntervalDayTime(String arg) {
            BigDecimal bd = new BigDecimal(arg);
            BigDecimal bdSeconds = new BigDecimal(bd.toBigInteger());
            BigDecimal bdNanos = bd.subtract(bdSeconds);
            return new HiveIntervalDayTime(0, 0, 0, bdSeconds.intValueExact(), bdNanos.multiply(NANOS_PER_SEC_BD).intValue());
        }
    }

    private static class IntervalMinuteLiteralProcessor
    extends AbstractDayTimeIntervalProcessor {
        private IntervalMinuteLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 791;
        }

        @Override
        protected HiveIntervalDayTime getIntervalDayTime(String arg) {
            return new HiveIntervalDayTime(0, 0, Integer.parseInt(arg), 0, 0);
        }
    }

    private static class IntervalHourLiteralProcessor
    extends AbstractDayTimeIntervalProcessor {
        private IntervalHourLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 790;
        }

        @Override
        protected HiveIntervalDayTime getIntervalDayTime(String arg) {
            return new HiveIntervalDayTime(0, Integer.parseInt(arg), 0, 0, 0);
        }
    }

    private static class IntervalDayLiteralProcessor
    extends AbstractDayTimeIntervalProcessor {
        private IntervalDayLiteralProcessor() {
        }

        @Override
        public Integer getKey() {
            return 787;
        }

        @Override
        protected HiveIntervalDayTime getIntervalDayTime(String arg) {
            return new HiveIntervalDayTime(Integer.parseInt(arg), 0, 0, 0, 0);
        }
    }

    private static abstract class AbstractYearMonthIntervalProcessor
    implements IntervalProcessor {
        private transient HiveIntervalYearMonthWritable intervalResult = new HiveIntervalYearMonthWritable();

        private AbstractYearMonthIntervalProcessor() {
        }

        @Override
        public final PrimitiveTypeInfo getTypeInfo() {
            return TypeInfoFactory.intervalYearMonthTypeInfo;
        }

        @Override
        public final Object evaluate(String arg) throws UDFArgumentException {
            this.intervalResult.set(this.getIntervalYearMonth(arg));
            return this.intervalResult;
        }

        protected abstract HiveIntervalYearMonth getIntervalYearMonth(String var1);
    }

    private static abstract class AbstractDayTimeIntervalProcessor
    implements IntervalProcessor {
        private transient HiveIntervalDayTimeWritable intervalResult = new HiveIntervalDayTimeWritable();

        private AbstractDayTimeIntervalProcessor() {
        }

        @Override
        public final PrimitiveTypeInfo getTypeInfo() {
            return TypeInfoFactory.intervalDayTimeTypeInfo;
        }

        @Override
        public final Object evaluate(String arg) throws UDFArgumentException {
            this.intervalResult.set(this.getIntervalDayTime(arg));
            return this.intervalResult;
        }

        protected abstract HiveIntervalDayTime getIntervalDayTime(String var1);
    }

    private static interface IntervalProcessor {
        public Integer getKey();

        public PrimitiveTypeInfo getTypeInfo();

        public Object evaluate(String var1) throws UDFArgumentException;
    }
}

