/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Normalizer;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaNormalizerExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaNormalizerExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{0, Vectors.dense((double)1.0, (double[])new double[]{0.1, -8.0})}), RowFactory.create((Object[])new Object[]{1, Vectors.dense((double)2.0, (double[])new double[]{1.0, -4.0})}), RowFactory.create((Object[])new Object[]{2, Vectors.dense((double)4.0, (double[])new double[]{10.0, 8.0})}));
        StructType schema = new StructType(new StructField[]{new StructField("id", DataTypes.IntegerType, false, Metadata.empty()), new StructField("features", (DataType)new VectorUDT(), false, Metadata.empty())});
        Dataset dataFrame = spark.createDataFrame(data, schema);
        Normalizer normalizer = ((Normalizer)((Normalizer)new Normalizer().setInputCol("features")).setOutputCol("normFeatures")).setP(1.0);
        Dataset l1NormData = normalizer.transform(dataFrame);
        l1NormData.show();
        Dataset lInfNormData = normalizer.transform(dataFrame, normalizer.p().w(Double.POSITIVE_INFINITY), new ParamPair[0]);
        lInfNormData.show();
        spark.stop();
    }
}

