/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.util.concurrent;

import java.util.concurrent.Callable;
import org.sparkproject.connect.guava.annotations.GwtCompatible;
import org.sparkproject.connect.guava.annotations.GwtIncompatible;
import org.sparkproject.connect.guava.annotations.J2ktIncompatible;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.base.Supplier;
import org.sparkproject.connect.guava.util.concurrent.AsyncCallable;
import org.sparkproject.connect.guava.util.concurrent.ListeningExecutorService;
import org.sparkproject.connect.guava.util.concurrent.ParametricNullness;

@GwtCompatible(emulated=true)
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(@ParametricNullness T value) {
        return () -> value;
    }

    @J2ktIncompatible
    @GwtIncompatible
    public static <T> AsyncCallable<T> asAsyncCallable(Callable<T> callable, ListeningExecutorService listeningExecutorService) {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(listeningExecutorService);
        return () -> listeningExecutorService.submit(callable);
    }

    @J2ktIncompatible
    @GwtIncompatible
    static <T> Callable<T> threadRenaming(Callable<T> callable, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    static Runnable threadRenaming(Runnable task, Supplier<String> nameSupplier) {
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(task);
        return () -> {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                task.run();
            }
            finally {
                if (restoreName) {
                    boolean bl = Callables.trySetName(oldName, currentThread);
                }
            }
        };
    }

    @J2ktIncompatible
    @GwtIncompatible
    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            currentThread.setName(threadName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

