/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.util.Map;
import java.util.UUID;
import org.apache.spark.connect.proto.CloneSessionRequest;
import org.apache.spark.connect.proto.CloneSessionResponse;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00013A\u0001B\u0003\u0001%!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u00032\u0001\u0011\u0005!\u0007C\u00037\u0001\u0011\u0005qGA\u0010Ta\u0006\u00148nQ8o]\u0016\u001cGo\u00117p]\u0016\u001cVm]:j_:D\u0015M\u001c3mKJT!AB\u0004\u0002\u000fM,'O^5dK*\u0011\u0001\"C\u0001\bG>tg.Z2u\u0015\tQ1\"A\u0002tc2T!\u0001D\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\r\u00011#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iiR\"A\u000e\u000b\u0005qY\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005yY\"a\u0002'pO\u001eLgnZ\u0001\u0011e\u0016\u001c\bo\u001c8tK>\u00137/\u001a:wKJ\u00042!\t\u0015+\u001b\u0005\u0011#BA\u0012%\u0003\u0011\u0019H/\u001e2\u000b\u0005\u00152\u0013\u0001B4sa\u000eT\u0011aJ\u0001\u0003S>L!!\u000b\u0012\u0003\u001dM#(/Z1n\u001f\n\u001cXM\u001d<feB\u00111fL\u0007\u0002Y)\u0011QFL\u0001\u0006aJ|Go\u001c\u0006\u0003\u0011-I!\u0001\r\u0017\u0003)\rcwN\\3TKN\u001c\u0018n\u001c8SKN\u0004xN\\:f\u0003\u0019a\u0014N\\5u}Q\u00111'\u000e\t\u0003i\u0001i\u0011!\u0002\u0005\u0006?\t\u0001\r\u0001I\u0001\u0007Q\u0006tG\r\\3\u0015\u0005aZ\u0004C\u0001\u000b:\u0013\tQTC\u0001\u0003V]&$\b\"\u0002\u001f\u0004\u0001\u0004i\u0014a\u0002:fcV,7\u000f\u001e\t\u0003WyJ!a\u0010\u0017\u0003'\rcwN\\3TKN\u001c\u0018n\u001c8SKF,Xm\u001d;")
public class SparkConnectCloneSessionHandler
implements Logging {
    private final StreamObserver<CloneSessionResponse> responseObserver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void handle(CloneSessionRequest request) {
        SessionKey sourceKey = new SessionKey(request.getUserContext().getUserId(), request.getSessionId());
        String newSessionId = request.hasNewSessionId() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(request.getNewSessionId())) ? request.getNewSessionId() : UUID.randomUUID().toString();
        None$ previouslyObservedSessionId = request.hasClientObservedServerSideSessionId() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(request.getClientObservedServerSideSessionId())) ? new Some((Object)request.getClientObservedServerSideSessionId()) : None$.MODULE$;
        SessionHolder originalSessionHolder = SparkConnectService$.MODULE$.sessionManager().getIsolatedSession(sourceKey, (Option<String>)previouslyObservedSessionId);
        SessionHolder clonedSessionHolder = SparkConnectService$.MODULE$.sessionManager().cloneSession(sourceKey, newSessionId, (Option<String>)previouslyObservedSessionId);
        CloneSessionResponse response = CloneSessionResponse.newBuilder().setSessionId(request.getSessionId()).setNewSessionId(clonedSessionHolder.sessionId()).setServerSideSessionId(originalSessionHolder.serverSessionId()).setNewServerSideSessionId(clonedSessionHolder.serverSessionId()).build();
        this.responseObserver.onNext(response);
        this.responseObserver.onCompleted();
    }

    public SparkConnectCloneSessionHandler(StreamObserver<CloneSessionResponse> responseObserver) {
        this.responseObserver = responseObserver;
        Logging.$init$((Logging)this);
    }
}

