/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh\u0001B\u0010!\u00015BQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001C\u0002\u0013%q\b\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0011\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019\u0011\u0007\u0001)A\u0005'\"91\r\u0001b\u0001\n\u0013!\u0007B\u00028\u0001A\u0003%Q\rC\u0003p\u0001\u0011%\u0001\u000f\u0003\u0005\u0002\f\u0001!\tAIA\u0007\u0011!\tY\u0002\u0001C\u0001E\u0005u\u0001\u0002CA\u0012\u0001\u0011\u0005!%!\n\t\u0011\u0005-\u0002\u0001\"\u0001#\u0003[Aq!!\u000f\u0001\t\u0013\tY\u0004C\u0004\u0002B\u0001!I!a\u0011\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!I\u00111\r\u0001\u0012\u0002\u0013%\u0011Q\r\u0005\b\u0003w\u0002A\u0011BA?\u0011%\t)\tAI\u0001\n\u0013\t)\u0007C\u0004\u0002\b\u0002!\t!!#\t\u0013\u0005=\u0005!%A\u0005\u0002\u0005\u0015\u0004\u0002CAI\u0001\u0011\u0005!%a%\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u00111\u0016\u0001\u0005\u0002\u0005]\u0005bBAW\u0001\u0011%\u00111\u0013\u0005\t\u0003_\u0003A\u0011\u0001\u0012\u00022\"9\u0011q\u0016\u0001\u0005\n\u0005u\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003+\u0004A\u0011BAl\u0011!\tY\u000e\u0001C\u0001E\u0005M\u0005\u0002CAo\u0001\u0011\u0005!%a8\u00035M\u0003\u0018M]6D_:tWm\u0019;TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005\u0005\u0012\u0013aB:feZL7-\u001a\u0006\u0003G\u0011\nqaY8o]\u0016\u001cGO\u0003\u0002&M\u0005\u00191/\u001d7\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u001b9\u001b\u00051$BA\u001c'\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001d7\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001f\u0011\u0005u\u0002Q\"\u0001\u0011\u0002\u0019M,7o]5p]N#xN]3\u0016\u0003\u0001\u0003B!\u0011%K\u001b6\t!I\u0003\u0002D\t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u00153\u0015\u0001B;uS2T\u0011aR\u0001\u0005U\u00064\u0018-\u0003\u0002J\u0005\ni1i\u001c8dkJ\u0014XM\u001c;NCB\u0004\"!P&\n\u00051\u0003#AC*fgNLwN\\&fsB\u0011QHT\u0005\u0003\u001f\u0002\u0012QbU3tg&|g\u000eS8mI\u0016\u0014\u0018!D:fgNLwN\\*u_J,\u0007%A\ndY>\u001cX\rZ*fgNLwN\\:DC\u000eDW-F\u0001T!\u0011!VLS0\u000e\u0003US!AV,\u0002\u000b\r\f7\r[3\u000b\u0005aK\u0016AB2p[6|gN\u0003\u0002[7\u00061qm\\8hY\u0016T\u0011\u0001X\u0001\u0004G>l\u0017B\u00010V\u0005\u0015\u0019\u0015m\u00195f!\ti\u0004-\u0003\u0002bA\t\t2+Z:tS>t\u0007j\u001c7eKJLeNZ8\u0002)\rdwn]3e'\u0016\u001c8/[8og\u000e\u000b7\r[3!\u0003E\u00198\r[3ek2,G-\u0012=fGV$xN]\u000b\u0002KB\u0019a-[6\u000e\u0003\u001dT!\u0001\u001b\"\u0002\r\u0005$x.\\5d\u0013\tQwMA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\t\tE.\u0003\u0002n\u0005\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002%M\u001c\u0007.\u001a3vY\u0016$W\t_3dkR|'\u000fI\u0001\u0012m\u0006d\u0017\u000eZ1uKN+7o]5p]&#G#B9um\u0006\u001d\u0001CA\u0018s\u0013\t\u0019\bG\u0001\u0003V]&$\b\"B;\t\u0001\u0004Q\u0015aA6fs\")q\u000f\u0003a\u0001q\u0006Y1/Z:tS>tW+V%E!\rI\u0018\u0011\u0001\b\u0003uz\u0004\"a\u001f\u0019\u000e\u0003qT!! \u0017\u0002\rq\u0012xn\u001c;?\u0013\ty\b'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fBBa!!\u0003\t\u0001\u0004A\u0018a\u00079sKZLw.^:ms>\u00137/\u001a:wK\u0012\u001cVm]:j_:LE-\u0001\u000ehKR|%o\u0011:fCR,\u0017j]8mCR,GmU3tg&|g\u000eF\u0003N\u0003\u001f\t\t\u0002C\u0003v\u0013\u0001\u0007!\nC\u0004\u0002\u0014%\u0001\r!!\u0006\u00029A\u0014XM^5pkNd\u0017p\u00142tKJ4X\rZ*fgN\u001c\u0018n\u001c8JIB!q&a\u0006y\u0013\r\tI\u0002\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002%\u001d,G/S:pY\u0006$X\rZ*fgNLwN\u001c\u000b\u0006\u001b\u0006}\u0011\u0011\u0005\u0005\u0006k*\u0001\rA\u0013\u0005\b\u0003'Q\u0001\u0019AA\u000b\u0003m9W\r^%t_2\fG/\u001a3TKN\u001c\u0018n\u001c8JMB\u0013Xm]3oiR!\u0011qEA\u0015!\u0011y\u0013qC'\t\u000bU\\\u0001\u0019\u0001&\u0002\u0019\rdwN\\3TKN\u001c\u0018n\u001c8\u0015\u000f5\u000by#a\r\u00028!1\u0011\u0011\u0007\u0007A\u0002)\u000b\u0011b]8ve\u000e,7*Z=\t\r\u0005UB\u00021\u0001y\u00031qWm^*fgNLwN\\%e\u0011\u001d\tI\u0001\u0004a\u0001\u0003+\t!D^1mS\u0012\fG/Z\"m_:,G+\u0019:hKR\u001cVm]:j_:$2!]A\u001f\u0011\u0019\ty$\u0004a\u0001\u0015\u00061a.Z<LKf\f!bZ3u'\u0016\u001c8/[8o)\u0015i\u0015QIA$\u0011\u0015)h\u00021\u0001K\u0011\u001d\tIE\u0004a\u0001\u0003\u0017\nq\u0001Z3gCVdG\u000fE\u00030\u0003/\ti\u0005\u0005\u00030\u0003\u001fj\u0015bAA)a\tIa)\u001e8di&|g\u000eM\u0001\u0014e\u0016lwN^3TKN\u001c\u0018n\u001c8I_2$WM\u001d\u000b\u0007\u0003O\t9&!\u0017\t\u000bU|\u0001\u0019\u0001&\t\u0013\u0005ms\u0002%AA\u0002\u0005u\u0013AD1mY><(+Z2p]:,7\r\u001e\t\u0004_\u0005}\u0013bAA1a\t9!i\\8mK\u0006t\u0017!\b:f[>4XmU3tg&|g\u000eS8mI\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d$\u0006BA/\u0003SZ#!a\u001b\u0011\t\u00055\u0014qO\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k\u0002\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011PA8\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016g\",H\u000fZ8x]N+7o]5p]\"{G\u000eZ3s)\u0015\t\u0018qPAB\u0011\u0019\t\t)\u0005a\u0001\u001b\u0006i1/Z:tS>t\u0007j\u001c7eKJD\u0011\"a\u0017\u0012!\u0003\u0005\r!!\u0018\u0002?MDW\u000f\u001e3po:\u001cVm]:j_:Du\u000e\u001c3fe\u0012\"WMZ1vYR$#'\u0001\u0007dY>\u001cXmU3tg&|g\u000eF\u0003r\u0003\u0017\u000bi\tC\u0003v'\u0001\u0007!\nC\u0005\u0002\\M\u0001\n\u00111\u0001\u0002^\u000512\r\\8tKN+7o]5p]\u0012\"WMZ1vYR$#'\u0001\u0005tQV$Hm\\<o)\u0005\t\u0018A\u00057jgR\f5\r^5wKN+7o]5p]N,\"!!'\u0011\u000b\u0005m\u0015QU0\u000f\t\u0005u\u0015\u0011\u0015\b\u0004w\u0006}\u0015\"A\u0019\n\u0007\u0005\r\u0006'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0016\u0011\u0016\u0002\u0004'\u0016\f(bAARa\u0005\u0011B.[:u\u00072|7/\u001a3TKN\u001c\u0018n\u001c8t\u0003Y\u00198\r[3ek2,\u0007+\u001a:j_\u0012L7m\u00115fG.\u001c\u0018a\u00059fe&|G-[2NC&tG/\u001a8b]\u000e,GcA9\u00024\"9\u0011QW\rA\u0002\u0005]\u0016\u0001\u00073fM\u0006,H\u000e^%oC\u000e$\u0018N^3US6,w.\u001e;NgB\u0019q&!/\n\u0007\u0005m\u0006G\u0001\u0003M_:<G#B9\u0002@\u0006\u0005\u0007bBA[5\u0001\u0007\u0011q\u0017\u0005\b\u0003\u0007T\u0002\u0019AA/\u0003MIwM\\8sK\u000e+8\u000f^8n)&lWm\\;u\u0003IqWm^%t_2\fG/\u001a3TKN\u001c\u0018n\u001c8\u0015\u0005\u0005%\u0007\u0003BAf\u0003#l!!!4\u000b\u0007\u0005=G%A\u0004dY\u0006\u001c8/[2\n\t\u0005M\u0017Q\u001a\u0002\r'B\f'o[*fgNLwN\\\u0001\u0016m\u0006d\u0017\u000eZ1uKN+7o]5p]\u000e\u0013X-\u0019;f)\r\t\u0018\u0011\u001c\u0005\u0006kr\u0001\rAS\u0001\u0016S:4\u0018\r\\5eCR,\u0017\t\u001c7TKN\u001c\u0018n\u001c8t\u0003Q\u0001X\u000f^*fgNLwN\u001c$peR+7\u000f^5oOR\u0019\u0011/!9\t\r\u0005\u0005e\u00041\u0001N\u0001")
public class SparkConnectSessionManager
implements Logging {
    private final ConcurrentMap<SessionKey, SessionHolder> sessionStore;
    private final Cache<SessionKey, SessionHolderInfo> closedSessionsCache;
    private final AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<SessionKey, SessionHolder> sessionStore() {
        return this.sessionStore;
    }

    private Cache<SessionKey, SessionHolderInfo> closedSessionsCache() {
        return this.closedSessionsCache;
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void validateSessionId(SessionKey key, String sessionUUID, String previouslyObservedSessionId) {
        String string = sessionUUID;
        String string2 = previouslyObservedSessionId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CHANGED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public SessionHolder getOrCreateIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.validateSessionCreate(key);
            SessionHolder holder = new SessionHolder(key.userId(), key.sessionId(), this.newIsolatedSession());
            holder.initializeSession();
            return holder;
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public SessionHolder getIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Session not found: " + key);
            if (this.closedSessionsCache().getIfPresent((Object)key) != null) {
                throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
            }
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public Option<SessionHolder> getIsolatedSessionIfPresent(SessionKey key) {
        return Option$.MODULE$.apply((Object)this.getSession(key, (Option<Function0<SessionHolder>>)None$.MODULE$));
    }

    public SessionHolder cloneSession(SessionKey sourceKey, String newSessionId, Option<String> previouslyObservedSessionId) {
        SessionHolder sourceSessionHolder = this.getIsolatedSession(sourceKey, (Option<String>)None$.MODULE$);
        previouslyObservedSessionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(sourceKey, sourceSessionHolder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        SessionKey newKey = new SessionKey(sourceKey.userId(), newSessionId);
        this.validateCloneTargetSession(newKey);
        SessionHolder clonedSessionHolder = this.getSession(newKey, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            SessionHolder session = (SessionHolder)this.sessionStore().get(newKey);
            if (session == null) {
                SparkSession clonedSparkSession = sourceSessionHolder.session().cloneSession();
                SessionHolder newHolder = new SessionHolder(newKey.userId(), newKey.sessionId(), clonedSparkSession);
                newHolder.initializeSession();
                return newHolder;
            }
            return session;
        }));
        return clonedSessionHolder;
    }

    private void validateCloneTargetSession(SessionKey newKey) {
        try {
            UUID.fromString(newKey.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent((Object)newKey) != null) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_ALREADY_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})));
        }
        if (this.sessionStore().containsKey(newKey)) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})));
        }
    }

    private SessionHolder getSession(SessionKey key, Option<Function0<SessionHolder>> option) {
        SessionHolder session;
        block4: {
            SessionHolder sessionHolder;
            this.schedulePeriodicChecks();
            Option<Function0<SessionHolder>> option2 = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Function0 callable = (Function0)some.value();
                sessionHolder = this.sessionStore().computeIfAbsent(key, x$1 -> (SessionHolder)callable.apply());
            } else if (None$.MODULE$.equals(option2)) {
                sessionHolder = (SessionHolder)this.sessionStore().get(key);
            } else {
                throw new MatchError(option2);
            }
            session = sessionHolder;
            if (session == null) break block4;
            session.updateAccessTime();
        }
        return session;
    }

    private Option<SessionHolder> removeSessionHolder(SessionKey key, boolean allowReconnect) {
        None$ sessionHolder = None$.MODULE$;
        sessionHolder = Option$.MODULE$.apply(this.sessionStore().get(key));
        sessionHolder.foreach((Function1 & Serializable)s -> {
            block0: {
                if (allowReconnect) break block0;
                this.closedSessionsCache().put((Object)s.key(), (Object)s.getSessionHolderInfo());
            }
            return (SessionHolder)this.sessionStore().remove(key);
        });
        return sessionHolder;
    }

    private boolean removeSessionHolder$default$2() {
        return false;
    }

    private void shutdownSessionHolder(SessionHolder sessionHolder, boolean allowReconnect) {
        sessionHolder.close();
        if (!allowReconnect) {
            this.closedSessionsCache().put((Object)sessionHolder.key(), (Object)sessionHolder.getSessionHolderInfo());
            return;
        }
    }

    public void closeSession(SessionKey key, boolean allowReconnect) {
        Option<SessionHolder> sessionHolder = this.removeSessionHolder(key, allowReconnect);
        sessionHolder.foreach((Function1 & Serializable)x$2 -> {
            this.shutdownSessionHolder(x$2, allowReconnect);
            return BoxedUnit.UNIT;
        });
    }

    public boolean closeSession$default$2() {
        return false;
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.sessionStore().clear();
        this.closedSessionsCache().invalidateAll();
    }

    private boolean shutdownSessionHolder$default$2() {
        return false;
    }

    public Seq<SessionHolderInfo> listActiveSessions() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.sessionStore().values()).asScala().map((Function1 & Serializable)x$3 -> x$3.getSessionHolderInfo())).toSeq();
    }

    public Seq<SessionHolderInfo> listClosedSessions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.closedSessionsCache().asMap()).asScala().values().toSeq();
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of expired sessions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.INTERVAL, BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long defaultInactiveTimeoutMs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT()));
                        this.periodicMaintenance(defaultInactiveTimeoutMs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long defaultInactiveTimeoutMs) {
        this.periodicMaintenance(defaultInactiveTimeoutMs, false);
    }

    private void periodicMaintenance(long defaultInactiveTimeoutMs, boolean ignoreCustomTimeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectSessionManager maintenance.");
        long nowMs = System.currentTimeMillis();
        this.sessionStore().forEach((x$4, sessionHolder) -> {
            SessionHolderInfo info = sessionHolder.getSessionHolderInfo();
            if (SparkConnectSessionManager.shouldExpire$1(info, nowMs, ignoreCustomTimeout, defaultInactiveTimeoutMs)) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found session ", " that expired "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SESSION_HOLD_INFO, info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and will be closed."}))).log((Seq)Nil$.MODULE$))));
                this.removeSessionHolder(info.key(), this.removeSessionHolder$default$2());
                try {
                    this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception closing session", throwable2);
                    }
                    throw throwable;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectSessionManager maintenance.");
    }

    private SparkSession newIsolatedSession() {
        SparkSession active = SparkSession$.MODULE$.active();
        if (active.sparkContext().isStopped()) {
            Predef$.MODULE$.assert(SparkSession$.MODULE$.getDefaultSession().nonEmpty());
            return ((SparkSession)SparkSession$.MODULE$.getDefaultSession().get()).newSession();
        }
        return active.newSession();
    }

    private void validateSessionCreate(SessionKey key) {
        try {
            UUID.fromString(key.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent((Object)key) != null) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public void invalidateAllSessions() {
        this.sessionStore().forEach((key, sessionHolder) -> {
            this.removeSessionHolder((SessionKey)key, this.removeSessionHolder$default$2());
            this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
        });
        this.closedSessionsCache().invalidateAll();
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.sessionStore().put(sessionHolder.key(), sessionHolder);
    }

    private static final boolean shouldExpire$1(SessionHolderInfo info, long nowMs, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1) {
        long timeoutMs = info.customInactiveTimeoutMs().isDefined() && !ignoreCustomTimeout$1 ? BoxesRunTime.unboxToLong((Object)info.customInactiveTimeoutMs().get()) : defaultInactiveTimeoutMs$1;
        return timeoutMs != -1L && info.lastAccessTimeMs() + timeoutMs <= nowMs;
    }

    public SparkConnectSessionManager() {
        Logging.$init$((Logging)this);
        this.sessionStore = new ConcurrentHashMap<SessionKey, SessionHolder>();
        this.closedSessionsCache = CacheBuilder.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE()))).build();
        this.scheduledExecutor = new AtomicReference();
    }
}

