/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ServiceLoader;
import java.util.UUID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.core.classloading.SubmoduleClassLoader;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcSystemLoader;
import org.apache.flink.runtime.rpc.akka.CleanupOnCloseRpcSystem;
import org.apache.flink.util.IOUtils;

public class AkkaRpcSystemLoader
implements RpcSystemLoader {
    public RpcSystem loadRpcSystem(Configuration config) {
        try {
            ClassLoader flinkClassLoader = RpcSystem.class.getClassLoader();
            Path tmpDirectory = Paths.get(ConfigurationUtils.parseTempDirectories((Configuration)config)[0], new String[0]);
            Files.createDirectories(tmpDirectory, new FileAttribute[0]);
            Path tempFile = Files.createFile(tmpDirectory.resolve("flink-rpc-akka_" + UUID.randomUUID() + ".jar"), new FileAttribute[0]);
            InputStream resourceStream = flinkClassLoader.getResourceAsStream("flink-rpc-akka.jar");
            if (resourceStream == null) {
                throw new RuntimeException("Akka RPC system could not be found. If this happened while running a test in the IDE,run the process-resources phase on flink-rpc/flink-rpc-akka-loader via maven.");
            }
            IOUtils.copyBytes((InputStream)resourceStream, (OutputStream)Files.newOutputStream(tempFile, new OpenOption[0]));
            SubmoduleClassLoader submoduleClassLoader = new SubmoduleClassLoader(new URL[]{tempFile.toUri().toURL()}, flinkClassLoader);
            return new CleanupOnCloseRpcSystem(ServiceLoader.load(RpcSystem.class, (ClassLoader)submoduleClassLoader).iterator().next(), submoduleClassLoader, tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize RPC system.", e);
        }
    }
}

