/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.enums.UserType;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.CommonService;
import org.apache.streampark.console.core.service.ProjectService;
import org.apache.streampark.console.core.service.VariableService;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.mapper.TeamMapper;
import org.apache.streampark.console.system.service.MemberService;
import org.apache.streampark.console.system.service.TeamService;
import org.apache.streampark.console.system.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class TeamServiceImpl
extends ServiceImpl<TeamMapper, Team>
implements TeamService {
    private static final Logger log = LoggerFactory.getLogger(TeamServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private MemberService memberService;
    @Autowired
    private VariableService variableService;
    @Autowired
    private CommonService commonService;

    @Override
    public IPage<Team> findTeams(Team team, RestRequest request) {
        Page page = new Page();
        page.setCurrent((long)request.getPageNum());
        page.setSize((long)request.getPageSize());
        return ((TeamMapper)this.baseMapper).findTeam((Page<Team>)page, team);
    }

    @Override
    public Team findByName(String teamName) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Team::getTeamName, (Object)teamName);
        return (Team)((TeamMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public void createTeam(Team team) {
        Team existedTeam = this.findByName(team.getTeamName());
        if (existedTeam != null) {
            throw new IllegalArgumentException(String.format("Team name [%s] was found, please rename and try again.", team.getTeamName()));
        }
        team.setId(null);
        team.setCreateTime(new Date());
        team.setModifyTime(team.getCreateTime());
        this.save(team);
    }

    @Override
    public void deleteTeam(Long teamId) {
        log.info("{} Proceed delete team[Id={}]", (Object)this.commonService.getCurrentUser().getUsername(), (Object)teamId);
        Team team = (Team)this.getById(teamId);
        if (team == null) {
            throw new ApiAlertException(String.format("The team[Id=%s] doesn't exists.", teamId));
        }
        if (this.applicationService.existsByTeamId(teamId)) {
            throw new ApiAlertException(String.format("Please delete the applications under the team[name=%s] first!", team.getTeamName()));
        }
        if (this.projectService.existsByTeamId(teamId).booleanValue()) {
            throw new ApiAlertException(String.format("Please delete the projects under the team[name=%s] first!", team.getTeamName()));
        }
        if (this.variableService.existsByTeamId(teamId)) {
            throw new ApiAlertException(String.format("Please delete the variables under the team[name=%s] first!", team.getTeamName()));
        }
        this.memberService.deleteByTeamId(teamId);
        this.userService.clearLastTeam(teamId);
        this.removeById(teamId);
    }

    @Override
    public void updateTeam(Team team) {
        Team oldTeam = (Team)Optional.ofNullable(this.getById(team)).orElseThrow(() -> new IllegalArgumentException(String.format("Team id [id=%s] not found", team.getId())));
        Utils.required((boolean)oldTeam.getTeamName().equals(team.getTeamName()), (Object)"Team name cannot be changed.");
        oldTeam.setDescription(team.getDescription());
        oldTeam.setModifyTime(new Date());
        this.updateById(oldTeam);
    }

    @Override
    public List<Team> findUserTeams(Long userId) {
        User user = (User)Optional.ofNullable(this.userService.getById(userId)).orElseThrow(() -> new IllegalArgumentException(String.format("The userId [%s] not found", userId)));
        if (UserType.ADMIN.equals((Object)user.getUserType())) {
            return this.list();
        }
        return ((TeamMapper)this.baseMapper).findUserTeams(userId);
    }
}

