/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.AuthorizationScope;

public class SecurityReference {
    private final String reference;
    private final List<AuthorizationScope> scopes;

    public SecurityReference(String reference, AuthorizationScope[] scopes) {
        this.scopes = Stream.of(scopes).collect(Collectors.toList());
        this.reference = reference;
    }

    public String getReference() {
        return this.reference;
    }

    public List<AuthorizationScope> getScopes() {
        return this.scopes;
    }

    public static SecurityReferenceBuilder builder() {
        return new SecurityReferenceBuilder();
    }

    public static class SecurityReferenceBuilder {
        private String reference;
        private AuthorizationScope[] scopes;

        public SecurityReferenceBuilder reference(String reference) {
            this.reference = BuilderDefaults.defaultIfAbsent(reference, this.reference);
            return this;
        }

        public SecurityReferenceBuilder scopes(AuthorizationScope[] scopes) {
            this.scopes = BuilderDefaults.defaultIfAbsent(scopes, this.scopes);
            return this;
        }

        public SecurityReference build() {
            return new SecurityReference(this.reference, this.scopes);
        }
    }
}

