/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression.operators.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class ExpressionList
implements ItemsList {
    private List<Expression> expressions;
    private boolean usingBrackets = true;

    public boolean isUsingBrackets() {
        return this.usingBrackets;
    }

    public void setUsingBrackets(boolean usingBrackets) {
        this.usingBrackets = usingBrackets;
    }

    public ExpressionList withUsingBrackets(boolean usingBrackets) {
        this.setUsingBrackets(usingBrackets);
        return this;
    }

    public ExpressionList() {
    }

    public ExpressionList(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public ExpressionList(Expression ... expressions) {
        this.expressions = new ArrayList<Expression>(Arrays.asList(expressions));
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public ExpressionList addExpressions(Expression ... elements) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(list, elements);
        return this.withExpressions(list);
    }

    public ExpressionList withExpressions(List<Expression> expressions) {
        this.setExpressions(expressions);
        return this;
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    @Deprecated
    public ExpressionList withBrackets(boolean brackets) {
        return this.withUsingBrackets(brackets);
    }

    @Override
    public void accept(ItemsListVisitor itemsListVisitor) {
        itemsListVisitor.visit(this);
    }

    public String toString() {
        return PlainSelect.getStringList(this.expressions, true, this.usingBrackets);
    }

    public ExpressionList addExpressions(Collection<? extends Expression> expressions) {
        List collection = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        collection.addAll(expressions);
        return this.withExpressions(collection);
    }
}

