/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.util.Preconditions;

public class InternalServiceDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;

    public InternalServiceDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        if (!this.kubernetesJobManagerParameters.isInternalServiceEnabled()) {
            return Collections.emptyList();
        }
        String serviceName = InternalServiceDecorator.getInternalServiceName(this.kubernetesJobManagerParameters.getClusterId());
        Service headlessService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceBuilder)new ServiceBuilder().withApiVersion("v1")).withNewMetadata().withName(serviceName)).withLabels(this.kubernetesJobManagerParameters.getCommonLabels())).endMetadata()).withNewSpec().withClusterIP("None")).withSelector(this.kubernetesJobManagerParameters.getLabels())).addNewPort().withName("jobmanager-rpc")).withPort(this.kubernetesJobManagerParameters.getRPCPort())).endPort()).addNewPort().withName("blobserver")).withPort(this.kubernetesJobManagerParameters.getBlobServerPort())).endPort()).endSpec()).build();
        String namespace = this.kubernetesJobManagerParameters.getNamespace();
        this.kubernetesJobManagerParameters.getFlinkConfiguration().setString(JobManagerOptions.ADDRESS, InternalServiceDecorator.getNamespacedInternalServiceName(serviceName, namespace));
        return Collections.singletonList(headlessService);
    }

    public static String getInternalServiceName(String clusterId) {
        return clusterId;
    }

    public static String getNamespacedInternalServiceName(String clusterId, String namespace) {
        return InternalServiceDecorator.getInternalServiceName(clusterId) + "." + namespace;
    }
}

