/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sorted.state;

import java.io.IOException;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.streaming.api.operators.sorted.state.MergingAbstractBatchExecutionKeyState;

class BatchExecutionKeyReducingState<K, N, T>
extends MergingAbstractBatchExecutionKeyState<K, N, T, T, T>
implements InternalReducingState<K, N, T> {
    private final ReduceFunction<T> reduceFunction;

    public BatchExecutionKeyReducingState(T defaultValue, ReduceFunction<T> reduceFunction, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<T> stateSerializer) {
        super(defaultValue, keySerializer, namespaceSerializer, stateSerializer);
        this.reduceFunction = reduceFunction;
    }

    public T get() {
        return (T)this.getOrDefault();
    }

    public void add(T value) throws IOException {
        if (value == null) {
            this.clear();
            return;
        }
        try {
            Object currentNamespaceValue = this.getCurrentNamespaceValue();
            if (currentNamespaceValue != null) {
                this.setCurrentNamespaceValue(this.reduceFunction.reduce(currentNamespaceValue, value));
            } else {
                this.setCurrentNamespaceValue(value);
            }
        }
        catch (Exception e) {
            throw new IOException("Exception while applying ReduceFunction in reducing state", e);
        }
    }

    static <T, K, N, SV, S extends State, IS extends S> IS create(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, StateDescriptor<S, SV> stateDesc) {
        return (IS)new BatchExecutionKeyReducingState<K, N, Object>(stateDesc.getDefaultValue(), ((ReducingStateDescriptor)stateDesc).getReduceFunction(), keySerializer, namespaceSerializer, stateDesc.getSerializer());
    }

    @Override
    protected T merge(T target, T source) throws Exception {
        return (T)this.reduceFunction.reduce(target, source);
    }
}

