/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.core.bean.AppBuildDockerResolvedDetail;
import org.apache.streampark.console.core.entity.AppBuildPipeline;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationLog;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.enums.Operation;
import org.apache.streampark.console.core.service.AppBuildPipeService;
import org.apache.streampark.console.core.service.ApplicationLogService;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.FlinkEnvService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.flink.packer.pipeline.DockerResolvedSnapshot;
import org.apache.streampark.flink.packer.pipeline.PipelineType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/pipe"})
public class ApplicationBuildPipelineController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationBuildPipelineController.class);
    @Autowired
    private AppBuildPipeService appBuildPipeService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkSqlService flinkSqlService;
    @Autowired
    private ApplicationLogService applicationLogService;
    @Autowired
    private FlinkEnvService flinkEnvService;

    @PermissionScope(app="#appId")
    @PostMapping(value={"build"})
    @RequiresPermissions(value={"app:create"})
    public RestResponse buildApplication(Long appId, boolean forceBuild) throws Exception {
        Application app = (Application)this.applicationService.getById(appId);
        ApiAlertException.throwIfNull(app.getVersionId(), "Please bind a Flink version to the current flink job.");
        FlinkEnv env = (FlinkEnv)this.flinkEnvService.getById(app.getVersionId());
        boolean checkVersion = env.getFlinkVersion().checkVersion(false);
        if (!checkVersion) {
            throw new ApiAlertException("Unsupported flink version: " + env.getFlinkVersion().version());
        }
        boolean envOk = this.applicationService.checkEnv(app);
        if (!envOk) {
            throw new ApiAlertException("Check flink env failed, please check the flink version of this job");
        }
        if (!forceBuild && !this.appBuildPipeService.allowToBuildNow(appId)) {
            throw new ApiAlertException("The job is invalid, or the job cannot be built while it is running");
        }
        ApplicationLog applicationLog = new ApplicationLog();
        applicationLog.setOptionName(Operation.RELEASE.getValue());
        applicationLog.setAppId(app.getId());
        applicationLog.setOptionTime(new Date());
        boolean needBuild = this.applicationService.checkBuildAndUpdate(app);
        if (!needBuild) {
            applicationLog.setSuccess(true);
            this.applicationLogService.save(applicationLog);
            return RestResponse.success(true);
        }
        if (app.isNeedRollback() && app.isFlinkSqlJob()) {
            this.flinkSqlService.rollback(app);
        }
        boolean actionResult = this.appBuildPipeService.buildApplication(app, applicationLog);
        return RestResponse.success(actionResult);
    }

    @PostMapping(value={"/detail"})
    @PermissionScope(app="#appId")
    @RequiresPermissions(value={"app:view"})
    public RestResponse getBuildProgressDetail(Long appId) {
        HashMap<String, AppBuildDockerResolvedDetail> details = new HashMap<String, AppBuildDockerResolvedDetail>(0);
        Optional<AppBuildPipeline> pipeline = this.appBuildPipeService.getCurrentBuildPipeline(appId);
        details.put("pipeline", pipeline.map(AppBuildPipeline::toView).orElse(null));
        if (pipeline.isPresent() && PipelineType.FLINK_NATIVE_K8S_APPLICATION == pipeline.get().getPipeType()) {
            DockerResolvedSnapshot dockerProgress = this.appBuildPipeService.getDockerProgressDetailSnapshot(appId);
            details.put("docker", AppBuildDockerResolvedDetail.of(dockerProgress));
        }
        return RestResponse.success(details);
    }
}

