/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.Collections;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.operators.sink.CommitRetrier;
import org.apache.flink.streaming.runtime.operators.sink.CommitterHandler;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

class CommitterOperator<InputT, OutputT>
extends AbstractStreamOperator<byte[]>
implements OneInputStreamOperator<byte[], byte[]>,
BoundedOneInput {
    private final SimpleVersionedSerializer<InputT> inputSerializer;
    private final CommitterHandler<InputT, OutputT> committerHandler;
    private final CommitRetrier commitRetrier;

    public CommitterOperator(ProcessingTimeService processingTimeService, SimpleVersionedSerializer<InputT> inputSerializer, CommitterHandler<InputT, OutputT> committerHandler) {
        this.inputSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(inputSerializer);
        this.committerHandler = (CommitterHandler)Preconditions.checkNotNull(committerHandler);
        this.processingTimeService = processingTimeService;
        this.commitRetrier = new CommitRetrier(processingTimeService, committerHandler);
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.committerHandler.initializeState(context);
        this.commitRetrier.retryWithDelay();
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.committerHandler.snapshotState(context);
    }

    @Override
    public void endInput() throws Exception {
        this.committerHandler.endOfInput();
        this.commitRetrier.retryIndefinitely();
    }

    @Override
    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        super.notifyCheckpointComplete(checkpointId);
        this.committerHandler.notifyCheckpointCompleted(checkpointId);
        this.commitRetrier.retryWithDelay();
    }

    @Override
    public void processElement(StreamRecord<byte[]> element) throws Exception {
        this.committerHandler.processCommittables(Collections.singletonList(SimpleVersionedSerialization.readVersionAndDeSerialize(this.inputSerializer, (byte[])element.getValue())));
    }

    @Override
    public void close() throws Exception {
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.committerHandler, () -> super.close()});
    }
}

