/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.yaml.snakeyaml.Yaml;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class PropertiesUtils$
implements Logger {
    public static PropertiesUtils$ MODULE$;
    private Pattern PROPERTY_PATTERN;
    private String MULTI_PROPERTY_REGEXP;
    private Pattern MULTI_PROPERTY_PATTERN;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new PropertiesUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private Pattern PROPERTY_PATTERN$lzycompute() {
        PropertiesUtils$ propertiesUtils$ = this;
        synchronized (propertiesUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PROPERTY_PATTERN = Pattern.compile("(.*?)=(.*?)");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.PROPERTY_PATTERN;
    }

    private Pattern PROPERTY_PATTERN() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PROPERTY_PATTERN$lzycompute() : this.PROPERTY_PATTERN;
    }

    private String MULTI_PROPERTY_REGEXP$lzycompute() {
        PropertiesUtils$ propertiesUtils$ = this;
        synchronized (propertiesUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.MULTI_PROPERTY_REGEXP = "-D(.*?)\\s*=\\s*[\\\"|'](.*)[\\\"|']";
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.MULTI_PROPERTY_REGEXP;
    }

    private String MULTI_PROPERTY_REGEXP() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.MULTI_PROPERTY_REGEXP$lzycompute() : this.MULTI_PROPERTY_REGEXP;
    }

    private Pattern MULTI_PROPERTY_PATTERN$lzycompute() {
        PropertiesUtils$ propertiesUtils$ = this;
        synchronized (propertiesUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.MULTI_PROPERTY_PATTERN = Pattern.compile(this.MULTI_PROPERTY_REGEXP());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.MULTI_PROPERTY_PATTERN;
    }

    private Pattern MULTI_PROPERTY_PATTERN() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.MULTI_PROPERTY_PATTERN$lzycompute() : this.MULTI_PROPERTY_PATTERN;
    }

    public String readFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(43).append("[StreamPark] readFile: file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(49).append("[StreamPark] readFile: file ").append(file).append(" is not a normal file").toString());
        Scanner scanner = new Scanner(file);
        StringBuilder buffer = new StringBuilder();
        while (scanner.hasNextLine()) {
            buffer.append(scanner.nextLine()).append("\r\n");
        }
        scanner.close();
        return buffer.toString();
    }

    private scala.collection.immutable.Map<String, String> eachYamlItem(String k, Object v, String prefix, scala.collection.mutable.Map<String, String> proper) {
        scala.collection.immutable.Map map;
        Object object = v;
        if (object instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((Map)linkedHashMap).flatMap((Function1 & Serializable & scala.Serializable)x -> {
                String string = prefix;
                scala.collection.immutable.Map<String, String> map = "".equals(string) ? MODULE$.eachYamlItem((String)x._1(), x._2(), k, proper) : MODULE$.eachYamlItem((String)x._1(), x._2(), new java.lang.StringBuilder(1).append(string).append(".").append(k).toString(), proper);
                return map;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            BoxedUnit boxedUnit;
            if (object != null) {
                String value = object.toString().trim();
                String string = prefix;
                scala.collection.mutable.Map map2 = "".equals(string) ? (scala.collection.mutable.Map)proper.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)value)) : (scala.collection.mutable.Map)proper.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new java.lang.StringBuilder(1).append(string).append(".").append(k).toString()), (Object)value));
                boxedUnit = map2;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            map = proper.toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    private String eachYamlItem$default$3() {
        return "";
    }

    private scala.collection.mutable.Map<String, String> eachYamlItem$default$4() {
        return (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public scala.collection.immutable.Map<String, String> fromYamlText(String text) {
        scala.collection.immutable.Map map;
        try {
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((Map)new Yaml().load(text)).flatMap((Function1 & Serializable & scala.Serializable)x -> MODULE$.eachYamlItem((String)x._1(), x._2(), MODULE$.eachYamlItem$default$3(), MODULE$.eachYamlItem$default$4()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading conf error:", e);
        }
        return map;
    }

    public scala.collection.immutable.Map<String, String> fromHoconText(String conf) {
        scala.collection.immutable.Map<String, String> map;
        Predef$.MODULE$.require(conf != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromHoconText: Hocon content must not be null");
        try {
            map = this.parseHoconByReader(new StringReader(conf));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading Hocon ", e);
        }
        return map;
    }

    public scala.collection.immutable.Map<String, String> fromPropertiesText(String conf) {
        scala.collection.immutable.Map map;
        try {
            Properties properties = new Properties();
            properties.load(new StringReader(conf));
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(properties.stringPropertyNames()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)properties.getProperty((String)k).trim()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading properties ", e);
        }
        return map;
    }

    public scala.collection.immutable.Map<String, String> fromYamlFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(52).append("[StreamPark] fromYamlFile: Yaml file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(58).append("[StreamPark] fromYamlFile: Yaml file ").append(file).append(" is not a normal file").toString());
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromYamlFile(inputStream);
    }

    public scala.collection.immutable.Map<String, String> fromHoconFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(48).append("[StreamPark] fromHoconFile: file ").append(file).append(" does not exist").toString());
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromHoconFile(inputStream);
    }

    public scala.collection.immutable.Map<String, String> fromPropertiesFile(String filename) {
        File file = new File(filename);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(64).append("[StreamPark] fromPropertiesFile: Properties file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(70).append("[StreamPark] fromPropertiesFile: Properties file ").append(file).append(" is not a normal file").toString());
        FileInputStream inputStream = new FileInputStream(file);
        return this.fromPropertiesFile(inputStream);
    }

    public scala.collection.immutable.Map<String, String> fromYamlFile(InputStream inputStream) {
        scala.collection.immutable.Map map;
        Predef$.MODULE$.require(inputStream != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromYamlFile: Properties inputStream  must not be null");
        try {
            try {
                map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap((Map)new Yaml().load(inputStream)).flatMap((Function1 & Serializable & scala.Serializable)x -> MODULE$.eachYamlItem((String)x._1(), x._2(), MODULE$.eachYamlItem$default$3(), MODULE$.eachYamlItem$default$4()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed when loading yaml from inputStream", e);
            }
        }
        finally {
            inputStream.close();
        }
        return map;
    }

    public scala.collection.immutable.Map<String, String> fromHoconFile(InputStream inputStream) {
        scala.collection.immutable.Map<String, String> map;
        Predef$.MODULE$.require(inputStream != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromHoconFile: Hocon inputStream  must not be null");
        try {
            map = this.parseHoconByReader(new InputStreamReader(inputStream));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading Hocon ", e);
        }
        return map;
    }

    private scala.collection.immutable.Map<String, String> parseHoconByReader(Reader reader) {
        scala.collection.immutable.Map map;
        try {
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(ConfigFactory.parseReader(reader).entrySet()).map((Function1 & Serializable & scala.Serializable)x -> {
                String k = ((String)x.getKey()).trim().replaceAll("\"", "");
                String v = ((ConfigValue)x.getValue()).unwrapped().toString().trim();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed when loading Hocon ", e);
        }
        return map;
    }

    public scala.collection.immutable.Map<String, String> fromPropertiesFile(InputStream inputStream) {
        scala.collection.immutable.Map map;
        Predef$.MODULE$.require(inputStream != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] fromPropertiesFile: Properties inputStream  must not be null");
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            map = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(properties.stringPropertyNames()).map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)properties.getProperty((String)k).trim()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("[StreamPark] Failed when loading properties from inputStream", e);
        }
        return map;
    }

    public HashMap<String, String> fromYamlTextAsJava(String text) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlText(text)).asJava());
    }

    public HashMap<String, String> fromHoconTextAsJava(String text) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconText(text)).asJava());
    }

    public HashMap<String, String> fromPropertiesTextAsJava(String text) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesText(text)).asJava());
    }

    public HashMap<String, String> fromYamlFileAsJava(String filename) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlFile(filename)).asJava());
    }

    public HashMap<String, String> fromHoconFileAsJava(String filename) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconFile(filename)).asJava());
    }

    public HashMap<String, String> fromPropertiesFileAsJava(String filename) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesFile(filename)).asJava());
    }

    public HashMap<String, String> fromYamlFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromYamlFile(inputStream)).asJava());
    }

    public HashMap<String, String> fromHoconFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromHoconFile(inputStream)).asJava());
    }

    public HashMap<String, String> fromPropertiesFileAsJava(InputStream inputStream) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.fromPropertiesFile(inputStream)).asJava());
    }

    public HashMap<String, String> loadFlinkConfYaml(File file) {
        Predef$.MODULE$.require(file != null && file.exists() && file.isFile(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] loadFlinkConfYaml: file must not be null");
        return this.loadFlinkConfYaml(FileUtils.readFileToString((File)file));
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<String, String> loadFlinkConfYaml(String yaml) {
        void var2_2;
        Predef$.MODULE$.require(yaml != null && new StringOps(Predef$.MODULE$.augmentString(yaml)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] loadFlinkConfYaml: yaml must not be null");
        HashMap flinkConf = new HashMap();
        Scanner scanner = new Scanner(yaml);
        AtomicInteger lineNo = new AtomicInteger(0);
        while (scanner.hasNextLine()) {
            BoxedUnit boxedUnit;
            String line = scanner.nextLine();
            lineNo.incrementAndGet();
            String[] comments = line.split("^#|\\s+#", 2);
            String conf = comments[0].trim();
            if (new StringOps(Predef$.MODULE$.augmentString(conf)).nonEmpty()) {
                String[] kv = conf.split(": ", 2);
                if (kv.length == 2) {
                    String key = kv[0].trim();
                    String value = kv[1].trim();
                    if (new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(value)).nonEmpty()) {
                        boxedUnit = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(flinkConf).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
                        continue;
                    }
                    this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(55).append("Error after splitting key and value in configuration ").append(lineNo.get()).append(": ").append(line).toString());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(63).append("Error while trying to split key and value in configuration. ").append(lineNo).append(" : ").append(line).toString());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    @Nonnull
    public scala.collection.immutable.Map<String, String> extractDynamicProperties(String properties) {
        scala.collection.immutable.Map map;
        if (StringUtils.isEmpty((CharSequence)properties)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            BoxedUnit boxedUnit;
            scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            String simple = properties.replaceAll(this.MULTI_PROPERTY_REGEXP(), "");
            String[] stringArray = simple.split("\\s?-D");
            if (Utils$.MODULE$.notEmpty(stringArray)) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stringArray)).foreach((Function1 & Serializable & scala.Serializable)x -> {
                    Matcher p;
                    return new StringOps(Predef$.MODULE$.augmentString(x)).nonEmpty() ? ((p = MODULE$.PROPERTY_PATTERN().matcher(x.trim())).matches() ? map2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.group(1).trim()), (Object)p.group(2).trim())) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Matcher matcher = this.MULTI_PROPERTY_PATTERN().matcher(properties);
            while (matcher.find()) {
                String opts = matcher.group();
                int index = opts.indexOf("=");
                String key = opts.substring(2, index).trim();
                String value = opts.substring(index + 1).trim().replaceAll("(^[\"|']|[\"|']$)", "");
                map2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
            }
            map = map2.toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    @Nonnull
    public List<String> extractArguments(String args) {
        ArrayBuffer programArgs = new ArrayBuffer();
        if (StringUtils.isNotEmpty((CharSequence)args)) {
            String[] array = args.split("\\s+");
            Iterator iter = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])array)).iterator();
            while (iter.hasNext()) {
                String regexp;
                ArrayBuffer arrayBuffer;
                String v = (String)iter.next();
                String p = (String)new StringOps(Predef$.MODULE$.augmentString(v)).take(1);
                String string = p;
                boolean bl = "'".equals(string) ? true : "\"".equals(string);
                if (bl) {
                    String value = v;
                    if (!v.endsWith(p)) {
                        while (!value.endsWith(p) && iter.hasNext()) {
                            value = new java.lang.StringBuilder(0).append(value).append(new java.lang.StringBuilder(1).append(" ").append(iter.next()).toString()).toString();
                        }
                    }
                    arrayBuffer = programArgs.$plus$eq((Object)value.substring(1, value.length() - 1));
                    continue;
                }
                String regexp2 = "(.*)='(.*)'$";
                arrayBuffer = v.matches(regexp2) ? programArgs.$plus$eq((Object)v.replaceAll(regexp2, "$1=$2")) : (v.matches(regexp = "(.*)=\"(.*)\"$") ? programArgs.$plus$eq((Object)v.replaceAll(regexp, "$1=$2")) : programArgs.$plus$eq((Object)v));
            }
        }
        return programArgs.toList();
    }

    @Nonnull
    public HashMap<String, String> extractDynamicPropertiesAsJava(String properties) {
        return new HashMap<String, String>((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.extractDynamicProperties(properties)).asJava());
    }

    private PropertiesUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

