/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.impl.AbstractFSBuilderImpl;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class FutureDataInputStreamBuilderImpl
extends AbstractFSBuilderImpl<CompletableFuture<FSDataInputStream>, FutureDataInputStreamBuilder>
implements FutureDataInputStreamBuilder {
    private final FileSystem fileSystem;
    private int bufferSize;
    private FileStatus status;

    protected FutureDataInputStreamBuilderImpl(@Nonnull FileContext fc, @Nonnull Path path) throws IOException {
        super(Objects.requireNonNull(path, "path"));
        Objects.requireNonNull(fc, "file context");
        this.fileSystem = null;
        this.bufferSize = 4096;
    }

    protected FutureDataInputStreamBuilderImpl(@Nonnull FileSystem fileSystem, @Nonnull Path path) {
        super(Objects.requireNonNull(path, "path"));
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem");
        this.initFromFS();
    }

    public FutureDataInputStreamBuilderImpl(@Nonnull FileSystem fileSystem, @Nonnull PathHandle pathHandle) {
        super(pathHandle);
        this.fileSystem = fileSystem;
        this.initFromFS();
    }

    private void initFromFS() {
        this.bufferSize = this.fileSystem.getConf().getInt("io.file.buffer.size", 4096);
    }

    protected FileSystem getFS() {
        Objects.requireNonNull(this.fileSystem, "fileSystem");
        return this.fileSystem;
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    public FutureDataInputStreamBuilder bufferSize(int bufSize) {
        this.bufferSize = bufSize;
        return this.getThisBuilder();
    }

    public FutureDataInputStreamBuilder builder() {
        return this.getThisBuilder();
    }

    @Override
    public FutureDataInputStreamBuilder getThisBuilder() {
        return this;
    }

    @Override
    public FutureDataInputStreamBuilder withFileStatus(FileStatus st) {
        this.status = Objects.requireNonNull(st, "status");
        return this;
    }

    protected FileStatus getStatus() {
        return this.status;
    }
}

