/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.resettable.NonReusingBlockResettableIterator;
import org.apache.flink.runtime.operators.resettable.SpillingResettableIterator;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMergeIterator<T1, T2, O>
implements JoinTaskIterator<T1, T2, O> {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected TypePairComparator<T1, T2> pairComparator;
    protected KeyGroupedIterator<T1> iterator1;
    protected KeyGroupedIterator<T2> iterator2;
    protected final TypeSerializer<T1> serializer1;
    protected final TypeSerializer<T2> serializer2;
    private final NonReusingBlockResettableIterator<T2> blockIt;
    private final IOManager ioManager;
    private final MemoryManager memoryManager;
    private final List<MemorySegment> memoryForSpillingIterator;
    protected T1 copy1;
    protected T1 spillHeadCopy;
    protected T2 copy2;
    protected T2 blockHeadCopy;

    public AbstractMergeIterator(MutableObjectIterator<T1> input1, MutableObjectIterator<T2> input2, TypeSerializer<T1> serializer1, TypeComparator<T1> comparator1, TypeSerializer<T2> serializer2, TypeComparator<T2> comparator2, TypePairComparator<T1, T2> pairComparator, MemoryManager memoryManager, IOManager ioManager, int numMemoryPages, AbstractInvokable parentTask) throws MemoryAllocationException {
        if (numMemoryPages < 2) {
            throw new IllegalArgumentException("Merger needs at least 2 memory pages.");
        }
        this.pairComparator = pairComparator;
        this.serializer1 = serializer1;
        this.serializer2 = serializer2;
        this.memoryManager = memoryManager;
        this.ioManager = ioManager;
        this.iterator1 = this.createKeyGroupedIterator(input1, serializer1, comparator1.duplicate());
        this.iterator2 = this.createKeyGroupedIterator(input2, serializer2, comparator2.duplicate());
        int numPagesForSpiller = numMemoryPages > 20 ? 2 : 1;
        this.blockIt = new NonReusingBlockResettableIterator<T2>(this.memoryManager, this.serializer2, numMemoryPages - numPagesForSpiller, parentTask);
        this.memoryForSpillingIterator = memoryManager.allocatePages(parentTask, numPagesForSpiller);
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() {
        if (this.blockIt != null) {
            try {
                this.blockIt.close();
            }
            catch (Throwable t) {
                this.LOG.error("Error closing block memory iterator: " + t.getMessage(), t);
            }
        }
        this.memoryManager.release(this.memoryForSpillingIterator);
    }

    @Override
    public void abort() {
        this.close();
    }

    @Override
    public abstract boolean callWithNextKey(FlatJoinFunction<T1, T2, O> var1, Collector<O> var2) throws Exception;

    protected void crossMatchingGroup(Iterator<T1> values1, Iterator<T2> values2, FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        T1 firstV1 = values1.next();
        T2 firstV2 = values2.next();
        boolean v1HasNext = values1.hasNext();
        boolean v2HasNext = values2.hasNext();
        if (v1HasNext) {
            if (v2HasNext) {
                this.crossMwithNValues(firstV1, values1, firstV2, values2, joinFunction, collector);
            } else {
                this.crossSecond1withNValues(firstV2, firstV1, values1, joinFunction, collector);
            }
        } else if (v2HasNext) {
            this.crossFirst1withNValues(firstV1, firstV2, values2, joinFunction, collector);
        } else {
            joinFunction.join(firstV1, firstV2, collector);
        }
    }

    private void crossFirst1withNValues(T1 val1, T2 firstValN, Iterator<T2> valsN, FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        T1 copy1 = this.createCopy(this.serializer1, val1, this.copy1);
        joinFunction.join(copy1, firstValN, collector);
        boolean more = true;
        do {
            T2 nRec = valsN.next();
            if (valsN.hasNext()) {
                copy1 = this.createCopy(this.serializer1, val1, this.copy1);
                joinFunction.join(copy1, nRec, collector);
                continue;
            }
            joinFunction.join(val1, nRec, collector);
            more = false;
        } while (more);
    }

    private void crossSecond1withNValues(T2 val1, T1 firstValN, Iterator<T1> valsN, FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        T2 copy2 = this.createCopy(this.serializer2, val1, this.copy2);
        joinFunction.join(firstValN, copy2, collector);
        boolean more = true;
        do {
            T1 nRec = valsN.next();
            if (valsN.hasNext()) {
                copy2 = this.createCopy(this.serializer2, val1, this.copy2);
                joinFunction.join(nRec, copy2, collector);
                continue;
            }
            joinFunction.join(nRec, val1, collector);
            more = false;
        } while (more);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crossMwithNValues(T1 firstV1, Iterator<T1> spillVals, T2 firstV2, Iterator<T2> blockVals, FlatJoinFunction<T1, T2, O> joinFunction, Collector<O> collector) throws Exception {
        T1 copy1 = this.createCopy(this.serializer1, firstV1, this.copy1);
        T2 blockHeadCopy = this.createCopy(this.serializer2, firstV2, this.blockHeadCopy);
        Object spillHeadCopy = null;
        joinFunction.join(copy1, firstV2, collector);
        SpillingResettableIterator<T1> spillIt = null;
        try {
            T1 nextSpillVal;
            Iterator<T1> leftSideIter;
            this.blockIt.reopen(blockVals);
            while (this.blockIt.hasNext()) {
                T2 nextBlockRec = this.blockIt.next();
                copy1 = this.createCopy(this.serializer1, firstV1, this.copy1);
                joinFunction.join(copy1, nextBlockRec, collector);
            }
            this.blockIt.reset();
            boolean spillingRequired = this.blockIt.hasFurtherInput();
            if (spillingRequired) {
                spillIt = new SpillingResettableIterator<T1>(spillVals, this.serializer1, this.memoryManager, this.ioManager, this.memoryForSpillingIterator);
                leftSideIter = spillIt;
                spillIt.open();
                spillHeadCopy = this.createCopy(this.serializer1, firstV1, this.spillHeadCopy);
            } else {
                leftSideIter = spillVals;
            }
            while (leftSideIter.hasNext()) {
                nextSpillVal = leftSideIter.next();
                copy1 = this.createCopy(this.serializer1, nextSpillVal, this.copy1);
                T2 copy2 = this.createCopy(this.serializer2, blockHeadCopy, this.copy2);
                joinFunction.join(copy1, copy2, collector);
                while (this.blockIt.hasNext()) {
                    T2 nextBlockRec = this.blockIt.next();
                    copy1 = this.createCopy(this.serializer1, nextSpillVal, this.copy1);
                    joinFunction.join(copy1, nextBlockRec, collector);
                }
                this.blockIt.reset();
            }
            if (!spillingRequired) {
                return;
            }
            while (this.blockIt.nextBlock()) {
                spillIt.reset();
                while (this.blockIt.hasNext()) {
                    copy1 = this.createCopy(this.serializer1, spillHeadCopy, this.copy1);
                    T2 nextBlockVal = this.blockIt.next();
                    joinFunction.join(copy1, nextBlockVal, collector);
                }
                this.blockIt.reset();
                while (spillIt.hasNext()) {
                    nextSpillVal = spillIt.next();
                    while (this.blockIt.hasNext()) {
                        T2 nextBlockVal = this.blockIt.next();
                        copy1 = this.createCopy(this.serializer1, nextSpillVal, this.copy1);
                        joinFunction.join(copy1, nextBlockVal, collector);
                    }
                    this.blockIt.reset();
                }
                spillIt.reset();
            }
        }
        finally {
            if (spillIt != null) {
                this.memoryForSpillingIterator.addAll(spillIt.close());
            }
        }
    }

    protected abstract <T> KeyGroupedIterator<T> createKeyGroupedIterator(MutableObjectIterator<T> var1, TypeSerializer<T> var2, TypeComparator<T> var3);

    protected abstract <T> T createCopy(TypeSerializer<T> var1, T var2, T var3);
}

