/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import com.google.inject.Binding;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.DefaultBindingScopingVisitor;
import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.sonatype.guice.bean.locators.BeanDescription;
import org.sonatype.guice.bean.locators.ImplementationVisitor;
import org.sonatype.guice.bean.locators.QualifiedBean;
import org.sonatype.inject.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LazyQualifiedBean<Q extends Annotation, T>
extends DefaultBindingScopingVisitor<Provider<T>>
implements QualifiedBean<Q, T> {
    private final Q qualifier;
    private final Binding<T> binding;
    private final Provider<T> provider;

    LazyQualifiedBean(Q qualifier, Binding<T> binding) {
        this.qualifier = qualifier;
        this.binding = binding;
        this.provider = (Provider)binding.acceptScopingVisitor((BindingScopingVisitor)this);
    }

    @Override
    public Q getKey() {
        return this.qualifier;
    }

    @Override
    public T getValue() {
        return this.provider.get();
    }

    @Override
    public T setValue(T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get() {
        return this.getValue();
    }

    @Override
    public String getDescription() {
        Description description;
        Object source = this.binding.getSource();
        if (source instanceof BeanDescription) {
            return ((BeanDescription)source).getDescription();
        }
        Class<T> clazz = this.getImplementationClass();
        if (null != clazz && null != (description = clazz.getAnnotation(Description.class))) {
            return description.value();
        }
        return null;
    }

    @Override
    public Class<T> getImplementationClass() {
        return (Class)this.binding.acceptTargetVisitor((BindingTargetVisitor)ImplementationVisitor.THIS);
    }

    @Override
    public Binding<? extends T> getBinding() {
        return this.binding;
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }

    public Provider<T> visitEagerSingleton() {
        return this.binding.getProvider();
    }

    public Provider<T> visitScope(Scope scope) {
        return Scopes.SINGLETON.equals(scope) ? this.visitEagerSingleton() : this.visitOther();
    }

    public Provider<T> visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
        return "Singleton".equals(scopeAnnotation.getSimpleName()) ? this.visitEagerSingleton() : this.visitOther();
    }

    protected Provider<T> visitOther() {
        return Scopes.SINGLETON.scope(this.binding.getKey(), this.binding.getProvider());
    }
}

