/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.validation.constraints.NotNull;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.bean.AlertTemplate;
import org.apache.streampark.console.core.entity.AlertConfig;
import org.apache.streampark.console.core.service.alert.AlertConfigService;
import org.apache.streampark.console.core.service.alert.AlertService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/flink/alert"})
public class AlertController {
    private static final Logger log = LoggerFactory.getLogger(AlertController.class);
    @Autowired
    private AlertConfigService alertConfigService;
    @Autowired
    private AlertService alertService;

    @PostMapping(value={"/add"})
    public RestResponse createAlertConfig(@RequestBody AlertConfigWithParams params) {
        boolean save = this.alertConfigService.save(AlertConfig.of(params));
        return RestResponse.success(save);
    }

    @PostMapping(value={"/exists"})
    public RestResponse verifyAlertConfig(@RequestBody AlertConfigWithParams params) {
        boolean exist = this.alertConfigService.exist(AlertConfig.of(params));
        return RestResponse.success(exist);
    }

    @PostMapping(value={"/update"})
    public RestResponse updateAlertConfig(@RequestBody AlertConfigWithParams params) {
        boolean update = this.alertConfigService.updateById(AlertConfig.of(params));
        return RestResponse.success(update);
    }

    @PostMapping(value={"/get"})
    public RestResponse getAlertConfig(@RequestBody AlertConfigWithParams params) {
        AlertConfig alertConfig = (AlertConfig)this.alertConfigService.getById(params.getId());
        return RestResponse.success(AlertConfigWithParams.of(alertConfig));
    }

    @PostMapping(value={"/list"})
    public RestResponse alertConfigsPaginationList(@RequestBody AlertConfigWithParams params, RestRequest request) {
        IPage<AlertConfigWithParams> page = this.alertConfigService.page(params, request);
        return RestResponse.success(page);
    }

    @PostMapping(value={"/listWithOutPage"})
    public RestResponse alertConfigsList() {
        List page = this.alertConfigService.list();
        return RestResponse.success(page);
    }

    @DeleteMapping(value={"/delete"})
    public RestResponse deleteAlertConfig(@RequestParam(value="id") @NotNull(message="config id must be not null") @NotNull(message="config id must be not null") Long id) {
        boolean result = this.alertConfigService.deleteById(id);
        return RestResponse.success(result);
    }

    @PostMapping(value={"/send"})
    public RestResponse sendAlert(Long id) throws AlertException {
        AlertTemplate alertTemplate = new AlertTemplate();
        alertTemplate.setTitle("Notify: StreamPark alert job for test");
        alertTemplate.setJobName("StreamPark alert job for test");
        alertTemplate.setSubject("StreamPark Alert: Test");
        alertTemplate.setStatus("TEST");
        alertTemplate.setType(1);
        alertTemplate.setRestart(false);
        Date date = new Date();
        alertTemplate.setStartTime(DateUtils.format((Date)date, (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault()));
        alertTemplate.setEndTime(DateUtils.format((Date)date, (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault()));
        alertTemplate.setDuration("-");
        boolean alert = this.alertService.alert(AlertConfigWithParams.of((AlertConfig)this.alertConfigService.getById(id)), alertTemplate);
        return RestResponse.success(alert);
    }
}

