/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.OperatorIDPair;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.util.FlinkRuntimeException;

public class VertexFinishedStateChecker {
    private final Set<ExecutionJobVertex> vertices;
    private final Map<OperatorID, OperatorState> operatorStates;

    public VertexFinishedStateChecker(Set<ExecutionJobVertex> vertices, Map<OperatorID, OperatorState> operatorStates) {
        this.vertices = vertices;
        this.operatorStates = operatorStates;
    }

    public void validateOperatorsFinishedState() {
        VerticesFinishedStatusCache verticesFinishedCache = new VerticesFinishedStatusCache(this.operatorStates);
        for (ExecutionJobVertex vertex : this.vertices) {
            VertexFinishedState vertexFinishedState = verticesFinishedCache.getOrUpdate(vertex);
            if (vertexFinishedState == VertexFinishedState.FULLY_FINISHED) {
                this.checkPredecessorsOfFullyFinishedVertex(vertex, verticesFinishedCache);
                continue;
            }
            if (vertexFinishedState != VertexFinishedState.PARTIALLY_FINISHED) continue;
            this.checkPredecessorsOfPartiallyFinishedVertex(vertex, verticesFinishedCache);
        }
    }

    private void checkPredecessorsOfFullyFinishedVertex(ExecutionJobVertex vertex, VerticesFinishedStatusCache verticesFinishedStatusCache) {
        boolean allPredecessorsFinished = vertex.getInputs().stream().map(IntermediateResult::getProducer).allMatch(jobVertex -> verticesFinishedStatusCache.getOrUpdate((ExecutionJobVertex)jobVertex) == VertexFinishedState.FULLY_FINISHED);
        if (!allPredecessorsFinished) {
            throw new FlinkRuntimeException("Illegal JobGraph modification. Cannot run a program with fully finished vertices predeceased with the ones not fully finished. Task vertex " + vertex.getName() + "(" + vertex.getJobVertexId() + ") has a predecessor not fully finished");
        }
    }

    private void checkPredecessorsOfPartiallyFinishedVertex(ExecutionJobVertex vertex, VerticesFinishedStatusCache verticesFinishedStatusCache) {
        HashMap<JobVertexID, DistributionPattern> predecessorDistribution = new HashMap<JobVertexID, DistributionPattern>();
        for (JobEdge jobEdge : vertex.getJobVertex().getInputs()) {
            predecessorDistribution.compute(jobEdge.getSource().getProducer().getID(), (k, v) -> v == DistributionPattern.ALL_TO_ALL ? v : jobEdge.getDistributionPattern());
        }
        for (IntermediateResult dataset : vertex.getInputs()) {
            ExecutionJobVertex predecessor = dataset.getProducer();
            VertexFinishedState predecessorState = verticesFinishedStatusCache.getOrUpdate(predecessor);
            DistributionPattern distribution = (DistributionPattern)((Object)predecessorDistribution.get(predecessor.getJobVertexId()));
            if (distribution == DistributionPattern.ALL_TO_ALL && predecessorState != VertexFinishedState.FULLY_FINISHED) {
                throw new FlinkRuntimeException("Illegal JobGraph modification. Cannot run a program with partially finished vertices predeceased with running or partially finished ones and connected via the ALL_TO_ALL edges. Task vertex " + vertex.getName() + "(" + vertex.getJobVertexId() + ") has a " + (predecessorState == VertexFinishedState.ALL_RUNNING ? "all running" : "partially finished") + " predecessor");
            }
            if (distribution != DistributionPattern.POINTWISE || predecessorState != VertexFinishedState.ALL_RUNNING) continue;
            throw new FlinkRuntimeException("Illegal JobGraph modification. Cannot run a program with partially finished vertices predeceased with all running ones. Task vertex " + vertex.getName() + "(" + vertex.getJobVertexId() + ") has a all running predecessor");
        }
    }

    private static class VerticesFinishedStatusCache {
        private final Map<OperatorID, OperatorState> operatorStates;
        private final Map<JobVertexID, VertexFinishedState> finishedCache = new HashMap<JobVertexID, VertexFinishedState>();

        private VerticesFinishedStatusCache(Map<OperatorID, OperatorState> operatorStates) {
            this.operatorStates = operatorStates;
        }

        public VertexFinishedState getOrUpdate(ExecutionJobVertex vertex) {
            return this.finishedCache.computeIfAbsent(vertex.getJobVertexId(), ignored -> this.calculateFinishedState(vertex, this.operatorStates));
        }

        private VertexFinishedState calculateFinishedState(ExecutionJobVertex vertex, Map<OperatorID, OperatorState> operatorStates) {
            Set operatorFinishedStates = vertex.getOperatorIDs().stream().map(idPair -> this.checkOperatorFinishedStatus(operatorStates, (OperatorIDPair)idPair)).collect(Collectors.toSet());
            if (operatorFinishedStates.size() != 1) {
                throw new FlinkRuntimeException("Can not restore vertex " + vertex.getName() + "(" + vertex.getJobVertexId() + ") which contain mixed operator finished state: " + operatorFinishedStates.stream().sorted().collect(Collectors.toList()));
            }
            return (VertexFinishedState)((Object)operatorFinishedStates.iterator().next());
        }

        private VertexFinishedState checkOperatorFinishedStatus(Map<OperatorID, OperatorState> operatorStates, OperatorIDPair idPair) {
            OperatorID operatorId = idPair.getUserDefinedOperatorID().filter(operatorStates::containsKey).orElse(idPair.getGeneratedOperatorID());
            return Optional.ofNullable(operatorStates.get((Object)operatorId)).map(operatorState -> {
                if (operatorState.isFullyFinished()) {
                    return VertexFinishedState.FULLY_FINISHED;
                }
                boolean hasFinishedSubtasks = operatorState.getSubtaskStates().values().stream().anyMatch(OperatorSubtaskState::isFinished);
                return hasFinishedSubtasks ? VertexFinishedState.PARTIALLY_FINISHED : VertexFinishedState.ALL_RUNNING;
            }).orElse(VertexFinishedState.ALL_RUNNING);
        }
    }

    @VisibleForTesting
    static enum VertexFinishedState {
        ALL_RUNNING,
        PARTIALLY_FINISHED,
        FULLY_FINISHED;

    }
}

