/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.CoGroupRawOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;

@Internal
public class CoGroupRawOperator<I1, I2, OUT>
extends TwoInputUdfOperator<I1, I2, OUT, CoGroupRawOperator<I1, I2, OUT>> {
    private final CoGroupFunction<I1, I2, OUT> function;
    private final Keys<I1> keys1;
    private final Keys<I2> keys2;
    private final String defaultName;

    public CoGroupRawOperator(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, CoGroupFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, String defaultName) {
        super(input1, input2, returnType);
        this.function = function;
        this.defaultName = defaultName;
        this.name = defaultName;
        if (keys1 == null || keys2 == null) {
            throw new NullPointerException();
        }
        this.keys1 = keys1;
        this.keys2 = keys2;
        this.extractSemanticAnnotationsFromUdf(function.getClass());
    }

    protected Keys<I1> getKeys1() {
        return this.keys1;
    }

    protected Keys<I2> getKeys2() {
        return this.keys2;
    }

    protected CoGroupRawOperatorBase<?, ?, OUT, ?> translateToDataFlow(Operator<I1> input1, Operator<I2> input2) {
        String name = this.getName() != null ? this.getName() : "CoGroup at " + this.defaultName;
        try {
            this.keys1.areCompatible(this.keys2);
        }
        catch (Keys.IncompatibleKeysException e) {
            throw new InvalidProgramException("The types of the key fields do not match.", (Throwable)e);
        }
        if (this.keys1 instanceof Keys.ExpressionKeys && this.keys2 instanceof Keys.ExpressionKeys) {
            try {
                this.keys1.areCompatible(this.keys2);
            }
            catch (Keys.IncompatibleKeysException e) {
                throw new InvalidProgramException("The types of the key fields do not match.", (Throwable)e);
            }
            int[] logicalKeyPositions1 = this.keys1.computeLogicalKeyPositions();
            int[] logicalKeyPositions2 = this.keys2.computeLogicalKeyPositions();
            CoGroupRawOperatorBase po = new CoGroupRawOperatorBase(this.function, new BinaryOperatorInformation(this.getInput1Type(), this.getInput2Type(), this.getResultType()), logicalKeyPositions1, logicalKeyPositions2, name);
            po.setFirstInput(input1);
            po.setSecondInput(input2);
            po.setParallelism(this.getParallelism());
            return po;
        }
        throw new UnsupportedOperationException("Unrecognized or incompatible key types.");
    }

    @Override
    protected Function getFunction() {
        return this.function;
    }
}

