/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.orderedgrouped;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.tez.common.CallableWithNdc;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.http.BaseHttpConnection;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.InputAttemptFetchFailure;
import org.apache.tez.runtime.library.common.shuffle.ShuffleUtils;
import org.apache.tez.runtime.library.common.shuffle.api.ShuffleHandlerError;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ExceptionReporter;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.FetchedInputAllocatorOrderedGrouped;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapHost;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.MapOutput;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleHeader;
import org.apache.tez.runtime.library.common.shuffle.orderedgrouped.ShuffleScheduler;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.exceptions.FetcherReadTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FetcherOrderedGrouped
extends CallableWithNdc<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(FetcherOrderedGrouped.class);
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final Configuration conf;
    private final boolean localDiskFetchEnabled;
    private final boolean verifyDiskChecksum;
    private final TezCounter connectionErrs;
    private final TezCounter ioErrs;
    private final TezCounter wrongLengthErrs;
    private final TezCounter badIdErrs;
    private final TezCounter wrongReduceErrs;
    private final FetchedInputAllocatorOrderedGrouped allocator;
    private final ShuffleScheduler scheduler;
    private final ExceptionReporter exceptionReporter;
    private final int id;
    private final String logIdentifier;
    private final RawLocalFileSystem localFs;
    private final String localShuffleHost;
    private final int localShufflePort;
    private final String applicationId;
    private final int dagId;
    protected final MapHost mapHost;
    private final int minPartition;
    private final int maxPartition;
    private final CompressionCodec codec;
    private final JobTokenSecretManager jobTokenSecretManager;
    final HttpConnectionParams httpConnectionParams;
    private final boolean sslShuffle;
    @VisibleForTesting
    volatile boolean stopped = false;
    private final boolean ifileReadAhead;
    private final int ifileReadAheadLength;
    @VisibleForTesting
    Map<String, InputAttemptIdentifier> remaining;
    volatile DataInputStream input;
    volatile BaseHttpConnection httpConnection;
    private final boolean asyncHttp;
    private final boolean compositeFetch;
    private long retryStartTime = 0L;
    private final Object cleanupLock = new Object();
    private static final InputAttemptFetchFailure[] EMPTY_ATTEMPT_ID_ARRAY = new InputAttemptFetchFailure[0];

    public FetcherOrderedGrouped(HttpConnectionParams httpConnectionParams, ShuffleScheduler scheduler, FetchedInputAllocatorOrderedGrouped allocator, ExceptionReporter exceptionReporter, JobTokenSecretManager jobTokenSecretMgr, boolean ifileReadAhead, int ifileReadAheadLength, CompressionCodec codec, Configuration conf, RawLocalFileSystem localFs, boolean localDiskFetchEnabled, String localHostname, int shufflePort, MapHost mapHost, TezCounter ioErrsCounter, TezCounter wrongLengthErrsCounter, TezCounter badIdErrsCounter, TezCounter wrongMapErrsCounter, TezCounter connectionErrsCounter, TezCounter wrongReduceErrsCounter, boolean asyncHttp, boolean sslShuffle, boolean verifyDiskChecksum, boolean compositeFetch, InputContext inputContext) {
        this.scheduler = scheduler;
        this.allocator = allocator;
        this.exceptionReporter = exceptionReporter;
        this.mapHost = mapHost;
        this.minPartition = this.mapHost.getPartitionId();
        this.maxPartition = this.minPartition + this.mapHost.getPartitionCount() - 1;
        this.id = nextId.incrementAndGet();
        this.jobTokenSecretManager = jobTokenSecretMgr;
        this.ioErrs = ioErrsCounter;
        this.wrongLengthErrs = wrongLengthErrsCounter;
        this.badIdErrs = badIdErrsCounter;
        this.connectionErrs = connectionErrsCounter;
        this.wrongReduceErrs = wrongReduceErrsCounter;
        this.applicationId = inputContext.getApplicationId().toString();
        this.dagId = inputContext.getDagIdentifier();
        this.ifileReadAhead = ifileReadAhead;
        this.ifileReadAheadLength = ifileReadAheadLength;
        this.httpConnectionParams = httpConnectionParams;
        this.asyncHttp = asyncHttp;
        this.codec = codec != null ? codec : null;
        this.conf = conf;
        this.localFs = localFs;
        this.localShuffleHost = localHostname;
        this.localShufflePort = shufflePort;
        this.localDiskFetchEnabled = localDiskFetchEnabled;
        this.sslShuffle = sslShuffle;
        this.verifyDiskChecksum = verifyDiskChecksum;
        this.compositeFetch = compositeFetch;
        String sourceDestNameTrimmed = TezUtilsInternal.cleanVertexName((String)inputContext.getSourceVertexName()) + " -> " + TezUtilsInternal.cleanVertexName((String)inputContext.getTaskVertexName());
        this.logIdentifier = "fetcher [" + sourceDestNameTrimmed + "] #" + this.id;
    }

    @VisibleForTesting
    protected void fetchNext() throws InterruptedException, IOException {
        try {
            if (this.localDiskFetchEnabled && this.mapHost.getHost().equals(this.localShuffleHost) && this.mapHost.getPort() == this.localShufflePort) {
                this.setupLocalDiskFetch(this.mapHost);
            } else {
                this.copyFromHost(this.mapHost);
            }
        }
        finally {
            this.cleanupCurrentConnection(false);
            this.scheduler.freeHost(this.mapHost);
        }
    }

    public Void callInternal() {
        try {
            this.remaining = null;
            this.fetchNext();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Throwable t) {
            this.exceptionReporter.reportException(t);
        }
        return null;
    }

    public void shutDown() {
        if (!this.stopped) {
            LOG.debug("Fetcher stopped for host {}", (Object)this.mapHost);
            this.stopped = true;
            this.cleanupCurrentConnection(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupCurrentConnection(boolean disconnect) {
        Object object = this.cleanupLock;
        synchronized (object) {
            try {
                if (this.httpConnection != null) {
                    this.httpConnection.cleanup(disconnect);
                    this.httpConnection = null;
                }
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Exception while shutting down fetcher " + this.logIdentifier, (Throwable)e);
                }
                LOG.info("Exception while shutting down fetcher " + this.logIdentifier + ": " + e.getMessage());
            }
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    protected void copyFromHost(MapHost host) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void invokeCopyFailedForFailedTasks(MapHost host, InputAttemptFetchFailure[] failedTasks) {
        if (failedTasks != null && failedTasks.length > 0) {
            if (this.stopped) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring copyMapOutput failures for tasks: " + Arrays.toString(failedTasks) + " since Fetcher has been stopped");
                }
            } else {
                LOG.warn("copyMapOutput failed for tasks " + Arrays.toString(failedTasks));
                for (InputAttemptFetchFailure left : failedTasks) {
                    this.scheduler.copyFailed(left, host, true, false);
                }
            }
        }
    }

    @VisibleForTesting
    boolean setupConnection(MapHost host, Collection<InputAttemptIdentifier> attempts) throws IOException {
        boolean connectSucceeded = false;
        StringBuilder baseURI = null;
        try {
            baseURI = ShuffleUtils.constructBaseURIForShuffleHandler(host.getHost(), host.getPort(), host.getPartitionId(), host.getPartitionCount(), this.applicationId, this.dagId, this.sslShuffle);
            URL url = ShuffleUtils.constructInputURL(baseURI.toString(), attempts, this.httpConnectionParams.isKeepAlive());
            this.httpConnection = ShuffleUtils.getHttpConnection(this.asyncHttp, url, this.httpConnectionParams, this.logIdentifier, this.jobTokenSecretManager);
            connectSucceeded = this.httpConnection.connect();
            if (this.stopped) {
                LOG.debug("Detected fetcher has been shutdown after connection establishment. Returning");
                return false;
            }
            this.setupConnectionInternal(host, attempts);
            return true;
        }
        catch (IOException | InterruptedException ie) {
            if (ie instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (this.stopped) {
                LOG.debug("Not reporting fetch failure, since an Exception was caught after shutdown");
                return false;
            }
            this.ioErrs.increment(1L);
            if (!connectSucceeded) {
                LOG.warn("FETCH_FAILURE: Failed to connect from {} to {} with {} inputs, url: {}", new Object[]{this.localShuffleHost, host, this.remaining.size(), baseURI, ie});
                this.connectionErrs.increment(1L);
            } else {
                LOG.warn("FETCH_FAILURE: Failed to verify reply after connecting from {} to {} with {} inputs pending, url: {}", new Object[]{this.localShuffleHost, host, this.remaining.size(), baseURI, ie});
            }
            for (InputAttemptIdentifier left : this.remaining.values()) {
                this.scheduler.copyFailed(InputAttemptFetchFailure.fromAttempt(left).withCause(ie), host, connectSucceeded, !connectSucceeded);
            }
            return false;
        }
    }

    protected void setupConnectionInternal(MapHost host, Collection<InputAttemptIdentifier> attempts) throws IOException, InterruptedException {
        this.input = this.httpConnection.getInputStream();
        this.httpConnection.validate();
    }

    @VisibleForTesting
    protected void putBackRemainingMapOutputs(MapHost host) {
        boolean isFirst = true;
        InputAttemptIdentifier first = null;
        for (InputAttemptIdentifier left : this.remaining.values()) {
            if (isFirst) {
                first = left;
                isFirst = false;
                continue;
            }
            this.scheduler.putBackKnownMapOutput(host, left);
        }
        if (first != null) {
            this.scheduler.putBackKnownMapOutput(host, first);
        }
    }

    protected InputAttemptFetchFailure[] copyMapOutput(MapHost host, DataInputStream input, InputAttemptIdentifier inputAttemptIdentifier) throws FetcherReadTimeoutException, IOException {
        MapOutput mapOutput = null;
        InputAttemptIdentifier srcAttemptId = null;
        long decompressedLength = 0L;
        long compressedLength = 0L;
        try {
            long startTime = System.currentTimeMillis();
            int partitionCount = 1;
            if (this.compositeFetch) {
                partitionCount = WritableUtils.readVInt((DataInput)input);
            }
            ArrayList<MapOutputStat> mapOutputStats = new ArrayList<MapOutputStat>(partitionCount);
            for (int mapOutputIndex = 0; mapOutputIndex < partitionCount; ++mapOutputIndex) {
                MapOutputStat mapOutputStat = null;
                try {
                    ShuffleHeader header = new ShuffleHeader();
                    header.readFields(input);
                    if (!header.mapId.startsWith("attempt")) {
                        if (!this.stopped) {
                            this.badIdErrs.increment(1L);
                            LOG.warn("Invalid map id: " + header.mapId + ", expected to start with " + "attempt" + ", partition: " + header.forReduce);
                            if (header.mapId.startsWith(ShuffleHandlerError.DISK_ERROR_EXCEPTION.toString())) {
                                return new InputAttemptFetchFailure[]{InputAttemptFetchFailure.fromDiskErrorAtSource(this.getNextRemainingAttempt())};
                            }
                            return new InputAttemptFetchFailure[]{InputAttemptFetchFailure.fromAttempt(this.getNextRemainingAttempt())};
                        }
                        LOG.debug("Already shutdown. Ignoring invalid map id error");
                        return EMPTY_ATTEMPT_ID_ARRAY;
                    }
                    if (header.getCompressedLength() == 0L) continue;
                    mapOutputStat = new MapOutputStat(this.scheduler.getIdentifierForFetchedOutput(header.mapId, header.forReduce), header.uncompressedLength, header.compressedLength, header.forReduce);
                    mapOutputStats.add(mapOutputStat);
                }
                catch (IllegalArgumentException e) {
                    if (!this.stopped) {
                        this.badIdErrs.increment(1L);
                        LOG.warn("Invalid map id ", (Throwable)e);
                        return new InputAttemptFetchFailure[]{new InputAttemptFetchFailure(this.getNextRemainingAttempt())};
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Already shutdown. Ignoring invalid map id error. Exception: " + e.getClass().getName() + ", Message: " + e.getMessage());
                    }
                    return EMPTY_ATTEMPT_ID_ARRAY;
                }
                if (!this.verifySanity(mapOutputStat.compressedLength, mapOutputStat.decompressedLength, mapOutputStat.forReduce, this.remaining, mapOutputStat.srcAttemptId)) {
                    if (!this.stopped) {
                        srcAttemptId = mapOutputStat.srcAttemptId;
                        if (srcAttemptId == null) {
                            srcAttemptId = this.getNextRemainingAttempt();
                            LOG.warn("Was expecting " + srcAttemptId + " but got null");
                        }
                        assert (srcAttemptId != null);
                        return new InputAttemptFetchFailure[]{new InputAttemptFetchFailure(this.getNextRemainingAttempt())};
                    }
                    LOG.debug("Already stopped. Ignoring verification failure.");
                    return EMPTY_ATTEMPT_ID_ARRAY;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("header: " + mapOutputStat.srcAttemptId + ", len: " + mapOutputStat.compressedLength + ", decomp len: " + mapOutputStat.decompressedLength);
            }
            for (MapOutputStat mapOutputStat : mapOutputStats) {
                srcAttemptId = mapOutputStat.srcAttemptId;
                decompressedLength = mapOutputStat.decompressedLength;
                compressedLength = mapOutputStat.compressedLength;
                try {
                    mapOutput = this.allocator.reserve(srcAttemptId, decompressedLength, compressedLength, this.id);
                }
                catch (IOException e) {
                    if (!this.stopped) {
                        this.ioErrs.increment(1L);
                        this.scheduler.reportLocalError(e);
                    } else {
                        LOG.debug("Already stopped. Ignoring error from merger.reserve");
                    }
                    return EMPTY_ATTEMPT_ID_ARRAY;
                }
                if (mapOutput.getType() == MapOutput.Type.WAIT) {
                    LOG.info("fetcher#" + this.id + " - MergerManager returned Status.WAIT ...");
                    return EMPTY_ATTEMPT_ID_ARRAY;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("fetcher#" + this.id + " about to shuffle output of map " + mapOutput.getAttemptIdentifier() + " decomp: " + decompressedLength + " len: " + compressedLength + " to " + (Object)((Object)mapOutput.getType()));
                }
                if (mapOutput.getType() == MapOutput.Type.MEMORY) {
                    ShuffleUtils.shuffleToMemory(mapOutput.getMemory(), input, (int)decompressedLength, (int)compressedLength, this.codec, this.ifileReadAhead, this.ifileReadAheadLength, LOG, mapOutput.getAttemptIdentifier());
                } else if (mapOutput.getType() == MapOutput.Type.DISK) {
                    ShuffleUtils.shuffleToDisk(mapOutput.getDisk(), host.getHostIdentifier(), input, compressedLength, decompressedLength, LOG, mapOutput.getAttemptIdentifier(), this.ifileReadAhead, this.ifileReadAheadLength, this.verifyDiskChecksum);
                } else {
                    throw new IOException("Unknown mapOutput type while fetching shuffle data:" + (Object)((Object)mapOutput.getType()));
                }
                long endTime = System.currentTimeMillis();
                this.retryStartTime = 0L;
                this.scheduler.copySucceeded(srcAttemptId, host, compressedLength, decompressedLength, endTime - startTime, mapOutput, false);
            }
            this.remaining.remove(inputAttemptIdentifier.toString());
        }
        catch (IOException | InternalError ioe) {
            if (this.stopped) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Not reporting fetch failure for exception during data copy: [" + ioe.getClass().getName() + ", " + ioe.getMessage() + "]");
                }
                this.cleanupCurrentConnection(true);
                if (mapOutput != null) {
                    mapOutput.abort();
                }
                return EMPTY_ATTEMPT_ID_ARRAY;
            }
            if (this.shouldRetry(host, ioe)) {
                if (mapOutput != null) {
                    mapOutput.abort();
                }
                throw new FetcherReadTimeoutException(ioe);
            }
            this.ioErrs.increment(1L);
            if (srcAttemptId == null || mapOutput == null) {
                LOG.info("fetcher#" + this.id + " failed to read map header" + srcAttemptId + " decomp: " + decompressedLength + ", " + compressedLength, ioe);
                if (srcAttemptId == null) {
                    return InputAttemptFetchFailure.fromAttempts(this.remaining.values());
                }
                return new InputAttemptFetchFailure[]{new InputAttemptFetchFailure(srcAttemptId)};
            }
            LOG.warn("Failed to shuffle output of " + srcAttemptId + " from " + host.getHostIdentifier(), ioe);
            mapOutput.abort();
            return new InputAttemptFetchFailure[]{new InputAttemptFetchFailure(srcAttemptId)};
        }
        return null;
    }

    private boolean shouldRetry(MapHost host, Throwable ioe) {
        if (!(ioe instanceof SocketTimeoutException)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (this.retryStartTime == 0L) {
            this.retryStartTime = currentTime;
        }
        if (currentTime - this.retryStartTime < (long)this.httpConnectionParams.getReadTimeout()) {
            LOG.warn("Shuffle output from " + host.getHostIdentifier() + " failed, retry it.");
            return true;
        }
        LOG.warn("Timeout for copying MapOutput with retry on host " + host + "after " + this.httpConnectionParams.getReadTimeout() + "milliseconds.");
        return false;
    }

    private boolean verifySanity(long compressedLength, long decompressedLength, int forReduce, Map<String, InputAttemptIdentifier> remaining, InputAttemptIdentifier srcAttemptId) {
        if (compressedLength < 0L || decompressedLength < 0L) {
            this.wrongLengthErrs.increment(1L);
            LOG.warn(this.logIdentifier + " invalid lengths in map output header: id: " + srcAttemptId + " len: " + compressedLength + ", decomp len: " + decompressedLength);
            return false;
        }
        if (forReduce < this.minPartition || forReduce > this.maxPartition) {
            this.wrongReduceErrs.increment(1L);
            LOG.warn(this.logIdentifier + " data for the wrong partition map: " + srcAttemptId + " len: " + compressedLength + " decomp len: " + decompressedLength + " for partition " + forReduce + ", expected partition range: " + this.minPartition + "-" + this.maxPartition);
            return false;
        }
        return true;
    }

    private InputAttemptIdentifier getNextRemainingAttempt() {
        if (this.remaining.size() > 0) {
            return this.remaining.values().iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void setupLocalDiskFetch(MapHost host) throws InterruptedException {
        List<InputAttemptIdentifier> srcAttempts = this.scheduler.getMapsForHost(host);
        if (srcAttempts.size() == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetcher " + this.id + " going to fetch (local disk) from " + host + " for: " + srcAttempts + ", partition range: " + this.minPartition + "-" + this.maxPartition);
        }
        this.populateRemainingMap(srcAttempts);
        try {
            Iterator<InputAttemptIdentifier> iter = this.remaining.values().iterator();
            while (iter.hasNext()) {
                if (this.stopped) {
                    return;
                }
                InputAttemptIdentifier srcAttemptId = iter.next();
                MapOutput mapOutput = null;
                boolean hasFailures = false;
                for (int curPartition = this.minPartition; curPartition <= this.maxPartition; ++curPartition) {
                    try {
                        long startTime = System.currentTimeMillis();
                        int reduceId = host.getPartitionId() + curPartition - this.minPartition;
                        srcAttemptId = this.scheduler.getIdentifierForFetchedOutput(srcAttemptId.getPathComponent(), reduceId);
                        Path filename = this.getShuffleInputFileName(srcAttemptId.getPathComponent(), null);
                        TezIndexRecord indexRecord = this.getIndexRecord(srcAttemptId.getPathComponent(), reduceId);
                        if (!indexRecord.hasData()) continue;
                        mapOutput = this.getMapOutputForDirectDiskFetch(srcAttemptId, filename, indexRecord);
                        long endTime = System.currentTimeMillis();
                        this.scheduler.copySucceeded(srcAttemptId, host, indexRecord.getPartLength(), indexRecord.getRawLength(), endTime - startTime, mapOutput, true);
                        continue;
                    }
                    catch (IOException | InternalError e) {
                        if (mapOutput != null) {
                            mapOutput.abort();
                        }
                        if (!this.stopped) {
                            hasFailures = true;
                            this.ioErrs.increment(1L);
                            this.scheduler.copyFailed(InputAttemptFetchFailure.fromLocalFetchFailure(srcAttemptId).withCause(e), host, true, false);
                            LOG.warn("Failed to read local disk output of " + srcAttemptId + " from " + host.getHostIdentifier(), e);
                            continue;
                        }
                        LOG.debug("Ignoring fetch error during local disk copy since fetcher has already been stopped");
                        this.putBackRemainingMapOutputs(host);
                        return;
                    }
                }
                if (hasFailures) continue;
                iter.remove();
            }
        }
        finally {
            this.putBackRemainingMapOutputs(host);
        }
    }

    @VisibleForTesting
    protected Path getShuffleInputFileName(String pathComponent, String suffix) throws IOException {
        LocalDirAllocator localDirAllocator = new LocalDirAllocator("tez.runtime.framework.local.dirs");
        suffix = suffix != null ? suffix : "";
        String outputPath = "output/" + pathComponent + "/" + "file.out" + suffix;
        String pathFromLocalDir = this.getPathForLocalDir(outputPath);
        return localDirAllocator.getLocalPathToRead(pathFromLocalDir.toString(), this.conf);
    }

    @VisibleForTesting
    protected TezIndexRecord getIndexRecord(String pathComponent, int partitionId) throws IOException {
        Path indexFile = this.getShuffleInputFileName(pathComponent, ".index");
        TezSpillRecord spillRecord = new TezSpillRecord(indexFile, (FileSystem)this.localFs);
        return spillRecord.getIndex(partitionId);
    }

    @VisibleForTesting
    protected MapOutput getMapOutputForDirectDiskFetch(InputAttemptIdentifier srcAttemptId, Path filename, TezIndexRecord indexRecord) throws IOException {
        return MapOutput.createLocalDiskMapOutput(srcAttemptId, this.allocator, filename, indexRecord.getStartOffset(), indexRecord.getPartLength(), true);
    }

    @VisibleForTesting
    void populateRemainingMap(List<InputAttemptIdentifier> origlist) {
        if (this.remaining == null) {
            this.remaining = new LinkedHashMap<String, InputAttemptIdentifier>(origlist.size());
        }
        for (InputAttemptIdentifier id : origlist) {
            this.remaining.put(id.toString(), id);
        }
    }

    private String getPathForLocalDir(String suffix) {
        if (ShuffleUtils.isTezShuffleHandler(this.conf)) {
            return "dag_" + this.dagId + "/" + suffix;
        }
        return suffix;
    }

    private static class MapOutputStat {
        final InputAttemptIdentifier srcAttemptId;
        final long decompressedLength;
        final long compressedLength;
        final int forReduce;

        MapOutputStat(InputAttemptIdentifier srcAttemptId, long decompressedLength, long compressedLength, int forReduce) {
            this.srcAttemptId = srcAttemptId;
            this.decompressedLength = decompressedLength;
            this.compressedLength = compressedLength;
            this.forReduce = forReduce;
        }

        public String toString() {
            return "id: " + this.srcAttemptId + ", decompressed length: " + this.decompressedLength + ", compressed length: " + this.compressedLength + ", reduce: " + this.forReduce;
        }
    }
}

