/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class AnnotationInstanceBuilder {
    private static final String VALUE = "value";
    private final DotName annotationType;
    private final boolean runtimeVisible;
    private final List<AnnotationValue> values = new ArrayList<AnnotationValue>();
    private final Set<String> alreadyAdded = new HashSet<String>();

    AnnotationInstanceBuilder(DotName annotationType, boolean runtimeVisible) {
        this.annotationType = annotationType;
        this.runtimeVisible = runtimeVisible;
    }

    public AnnotationInstanceBuilder add(AnnotationValue value) {
        if (!this.alreadyAdded.add(value.name())) {
            throw new IllegalArgumentException("Annotation member '" + value.name() + "' already added");
        }
        this.values.add(value);
        return this;
    }

    public AnnotationInstanceBuilder addAll(List<AnnotationValue> values) {
        for (AnnotationValue value : values) {
            this.add(value);
        }
        return this;
    }

    public AnnotationInstanceBuilder add(String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createBooleanValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, boolean[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createBooleanValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, byte value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createByteValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, byte[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createByteValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, short value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createShortValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, short[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createShortValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, int value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createIntegerValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, int[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createIntegerValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, long value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createLongValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, long[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createLongValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, float value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createFloatValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, float[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createFloatValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, double value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createDoubleValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, double[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createDoubleValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, char value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createCharacterValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, char[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createCharacterValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createStringValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, String[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createStringValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, Enum<?> value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        DotName enumTypeName = DotName.createSimple(value.getDeclaringClass().getName());
        String enumValue = value.name();
        this.values.add(AnnotationValue.createEnumValue(name, enumTypeName, enumValue));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, Enum<?>[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            DotName enumTypeName = DotName.createSimple(values[i].getDeclaringClass().getName());
            String enumValue = values[i].name();
            array[i] = AnnotationValue.createEnumValue(name, enumTypeName, enumValue);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, Class<? extends Enum<?>> enumType, String enumValue) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        DotName enumTypeName = DotName.createSimple(enumType.getName());
        this.values.add(AnnotationValue.createEnumValue(name, enumTypeName, enumValue));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, Class<? extends Enum<?>> enumType, String[] enumValues) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[enumValues.length];
        DotName enumTypeName = DotName.createSimple(enumType.getName());
        for (int i = 0; i < enumValues.length; ++i) {
            array[i] = AnnotationValue.createEnumValue(name, enumTypeName, enumValues[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, ClassInfo enumType, String enumValue) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        DotName enumTypeName = enumType.name();
        this.values.add(AnnotationValue.createEnumValue(name, enumTypeName, enumValue));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, ClassInfo enumType, String[] enumValues) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[enumValues.length];
        DotName enumTypeName = enumType.name();
        for (int i = 0; i < enumValues.length; ++i) {
            array[i] = AnnotationValue.createEnumValue(name, enumTypeName, enumValues[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, Class<?> value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        Type clazz = Type.create(value);
        this.values.add(AnnotationValue.createClassValue(name, clazz));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, Class<?>[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            Type clazz = Type.create(values[i]);
            array[i] = AnnotationValue.createClassValue(name, clazz);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, ClassInfo value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        DotName className = value.name();
        Type jandexClass = Type.create(className, Type.Kind.CLASS);
        this.values.add(AnnotationValue.createClassValue(name, jandexClass));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, ClassInfo[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            DotName className = values[i].name();
            Type jandexClass = Type.create(className, Type.Kind.CLASS);
            array[i] = AnnotationValue.createClassValue(name, jandexClass);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    private void validateType(Type type) {
        Type.Kind element;
        Type.Kind kind = type.kind();
        if (kind == Type.Kind.VOID || kind == Type.Kind.PRIMITIVE || kind == Type.Kind.CLASS) {
            return;
        }
        if (kind == Type.Kind.ARRAY && ((element = type.asArrayType().elementType().kind()) == Type.Kind.PRIMITIVE || element == Type.Kind.CLASS)) {
            return;
        }
        throw new IllegalArgumentException("Type can't be present in annotation: " + type);
    }

    public AnnotationInstanceBuilder add(String name, Type value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.validateType(value);
        this.values.add(AnnotationValue.createClassValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, Type[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.validateType(values[i]);
            array[i] = AnnotationValue.createClassValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, AnnotationInstance value) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        this.values.add(AnnotationValue.createNestedAnnotationValue(name, value));
        return this;
    }

    public AnnotationInstanceBuilder add(String name, AnnotationInstance[] values) {
        if (name == null) {
            throw new IllegalArgumentException("Annotation member name must be set");
        }
        if (!this.alreadyAdded.add(name)) {
            throw new IllegalArgumentException("Annotation member '" + name + "' already added");
        }
        AnnotationValue[] array = new AnnotationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            array[i] = AnnotationValue.createNestedAnnotationValue(name, values[i]);
        }
        this.values.add(AnnotationValue.createArrayValue(name, array));
        return this;
    }

    public AnnotationInstanceBuilder value(boolean value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(boolean[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(byte value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(byte[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(short value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(short[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(int value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(int[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(long value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(long[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(float value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(float[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(double value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(double[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(char value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(char[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(String value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(String[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(Enum<?> value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(Enum<?>[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(Class<? extends Enum<?>> enumType, String enumValue) {
        return this.add(VALUE, enumType, enumValue);
    }

    public AnnotationInstanceBuilder value(Class<? extends Enum<?>> enumType, String[] enumValues) {
        return this.add(VALUE, enumType, enumValues);
    }

    public AnnotationInstanceBuilder value(ClassInfo enumType, String enumValue) {
        return this.add(VALUE, enumType, enumValue);
    }

    public AnnotationInstanceBuilder value(ClassInfo enumType, String[] enumValues) {
        return this.add(VALUE, enumType, enumValues);
    }

    public AnnotationInstanceBuilder value(Class<?> value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(Class<?>[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(ClassInfo value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(ClassInfo[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(Type value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(Type[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder value(AnnotationInstance value) {
        return this.add(VALUE, value);
    }

    public AnnotationInstanceBuilder value(AnnotationInstance[] values) {
        return this.add(VALUE, values);
    }

    public AnnotationInstanceBuilder with(Consumer<AnnotationInstanceBuilder> action) {
        if (action == null) {
            throw new IllegalArgumentException("AnnotationInstanceBuilder#with action must be set");
        }
        action.accept(this);
        return this;
    }

    public AnnotationInstance build() {
        return AnnotationInstance.create(this.annotationType, this.runtimeVisible, null, this.values);
    }

    public AnnotationInstance buildWithTarget(AnnotationTarget target) {
        return AnnotationInstance.create(this.annotationType, this.runtimeVisible, target, this.values);
    }
}

