/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.metrics;

import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.util.Join;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class VendorMetrics {
    private static final Logger LOGGER = Logger.getLogger(VendorMetrics.class.getName());

    public void afterApplicationDeployed(@Observes AssemblerAfterApplicationCreated event) {
        Set<ObjectInstance> objectInstances;
        if ("none".equals(SystemInstance.get().getOptions().get("tomee.mp.scan", "none"))) {
            return;
        }
        MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)"vendor");
        if (!(registry instanceof LegacyMetricRegistryAdapter)) {
            return;
        }
        MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            objectInstances = platformMBeanServer.queryMBeans(new ObjectName("openejb.management:*"), null);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.severe("Unable to read MBeans under openejb.management");
            return;
        }
        for (ObjectInstance objectInstance : objectInstances) {
            ObjectName objectName = objectInstance.getObjectName();
            LOGGER.info("Adding vendor metrics for " + objectName);
            LOGGER.info("Class name: " + objectInstance.getClassName());
            ArrayList<String> nameParts = new ArrayList<String>();
            if (objectName.getKeyProperty("ObjectType") != null) {
                nameParts.add(objectName.getKeyProperty("ObjectType"));
                if (objectName.getKeyProperty("DataSource") != null) {
                    nameParts.add(objectName.getKeyProperty("DataSource"));
                }
            } else if (objectName.getKeyProperty("j2eeType") != null) {
                nameParts.add(objectName.getKeyProperty("j2eeType"));
                if (objectName.getKeyProperty("name") != null) {
                    nameParts.add(objectName.getKeyProperty("name"));
                }
            }
            String metricName = Join.join((String)"_", nameParts);
            try {
                MBeanInfo mBeanInfo = platformMBeanServer.getMBeanInfo(objectName);
                JMXInfo jmxInfo = JMXInfo.from(objectName, mBeanInfo);
                jmxInfo.configureMetrics(registry, metricName);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to configure metrics for " + objectName, e);
            }
        }
    }

    private static class JMXInfo {
        private final ObjectName objectName;
        private long lastUpdated = 0L;
        private Map<String, JMXAttribute> attributeMap = new HashMap<String, JMXAttribute>();

        private JMXInfo(ObjectName objectName) {
            this.objectName = objectName;
        }

        public static JMXInfo from(ObjectName objectName, MBeanInfo info) {
            List<JMXAttribute> attributes = Arrays.stream(info.getAttributes()).filter(a -> JMXAttribute.getType(a.getType()) != null).map(a -> JMXAttribute.from(a)).collect(Collectors.toList());
            JMXInfo jmxInfo = new JMXInfo(objectName);
            attributes.forEach(a -> jmxInfo.attributeMap.put(a.getAttributeName(), (JMXAttribute)a));
            return jmxInfo;
        }

        public synchronized void update() {
            AttributeList attributes;
            long timeNow = System.currentTimeMillis();
            if (timeNow - this.lastUpdated < 5000L) {
                return;
            }
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            String[] attributeNames = this.attributeMap.keySet().toArray(new String[0]);
            try {
                attributes = platformMBeanServer.getAttributes(this.objectName, attributeNames);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Unable to read metrics from JMX", e);
                return;
            }
            attributes.asList().forEach(a -> {
                String name = a.getName();
                Object value = a.getValue();
                if (!Number.class.isInstance(value)) {
                    return;
                }
                JMXAttribute jmxAttribute = this.attributeMap.get(name);
                if (jmxAttribute == null) {
                    return;
                }
                jmxAttribute.setCurrentValue((Number)Number.class.cast(value));
            });
            this.lastUpdated = timeNow;
        }

        public Double get(String attributeName) {
            this.update();
            JMXAttribute jmxAttribute = this.attributeMap.get(attributeName);
            if (jmxAttribute == null) {
                throw new IllegalArgumentException("Attribute name: " + attributeName + " not known");
            }
            return jmxAttribute.toDouble();
        }

        public void configureMetrics(MetricRegistry registry, String metricName) {
            this.attributeMap.values().forEach(a -> ((LegacyMetricRegistryAdapter)registry).counter(Metadata.builder().withName(metricName + "_" + a.getAttributeName()).build(), a.getType(), value -> this.get(a.attributeName), new Tag[0]));
        }
    }

    private static class JMXAttribute<T extends Number> {
        private final String attributeName;
        private final Class<T> type;
        private T currentValue;

        public JMXAttribute(String attributeName, Class<T> type) {
            this.attributeName = attributeName;
            this.type = type;
        }

        public static JMXAttribute from(MBeanAttributeInfo attributeInfo) {
            String name = attributeInfo.getName();
            Class<Number> t = JMXAttribute.getType(attributeInfo.getType());
            if (name == null || t == null) {
                throw new IllegalArgumentException("Class and type must be specified");
            }
            return new JMXAttribute<Number>(name, t);
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public Class<T> getType() {
            return this.type;
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(T currentValue) {
            this.currentValue = currentValue;
        }

        public Double toDouble() {
            if (this.currentValue == null) {
                return Double.NaN;
            }
            return ((Number)this.currentValue).doubleValue();
        }

        public String toString() {
            return this.attributeName + "(" + this.type.getName() + "): " + this.currentValue;
        }

        public static Class<? extends Number> getType(String type) {
            if ("int".equals(type)) {
                return Integer.class;
            }
            if ("long".equals(type)) {
                return Long.class;
            }
            if ("float".equals(type)) {
                return Float.class;
            }
            if ("double".equals(type)) {
                return Double.class;
            }
            return null;
        }
    }
}

