/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import jakarta.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.TransactionContext;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transaction.Synchronization;

public class ManagedTransactionContext
extends TransactionContext {
    private final TransactionContext sharedContext;
    private boolean useSharedTxContext;

    public ManagedTransactionContext(TransactionContext sharedContext) {
        super(sharedContext.getConnection());
        this.sharedContext = sharedContext;
        this.setLocalTransactionEventListener(sharedContext.getLocalTransactionEventListener());
    }

    public void setUseSharedTxContext(boolean enable) throws JMSException {
        if (this.isInLocalTransaction() || this.isInXATransaction()) {
            throw new JMSException("The resource is already being used in transaction context.");
        }
        this.useSharedTxContext = enable;
    }

    public void begin() throws JMSException {
        if (this.useSharedTxContext) {
            this.sharedContext.begin();
        } else {
            super.begin();
        }
    }

    public void commit() throws JMSException {
        if (this.useSharedTxContext) {
            this.sharedContext.commit();
        } else {
            super.commit();
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.commit(xid, onePhase);
        } else {
            super.commit(xid, onePhase);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.end(xid, flags);
        } else {
            super.end(xid, flags);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.forget(xid);
        } else {
            super.forget(xid);
        }
    }

    public TransactionId getTransactionId() {
        if (this.useSharedTxContext) {
            return this.sharedContext.getTransactionId();
        }
        return super.getTransactionId();
    }

    public int getTransactionTimeout() throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.getTransactionTimeout();
        }
        return super.getTransactionTimeout();
    }

    public boolean isInLocalTransaction() {
        if (this.useSharedTxContext) {
            return this.sharedContext.isInLocalTransaction();
        }
        return super.isInLocalTransaction();
    }

    public boolean isRollbackOnly() {
        return this.sharedContext.isRollbackOnly() || super.isRollbackOnly();
    }

    public boolean isInXATransaction() {
        if (this.useSharedTxContext) {
            return this.sharedContext.isInTransaction();
        }
        return super.isInXATransaction();
    }

    public boolean isInTransaction() {
        return this.isInXATransaction() || this.isInLocalTransaction();
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.isSameRM(xaResource);
        }
        return super.isSameRM(xaResource);
    }

    public int prepare(Xid xid) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.prepare(xid);
        }
        return super.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.recover(flag);
        }
        return super.recover(flag);
    }

    public void rollback() throws JMSException {
        if (this.useSharedTxContext) {
            this.sharedContext.rollback();
        } else {
            super.rollback();
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.rollback(xid);
        } else {
            super.rollback(xid);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.useSharedTxContext) {
            return this.sharedContext.setTransactionTimeout(seconds);
        }
        return super.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.useSharedTxContext) {
            this.sharedContext.start(xid, flags);
        } else {
            super.start(xid, flags);
        }
    }

    public void addSynchronization(Synchronization s) {
        if (this.useSharedTxContext) {
            this.sharedContext.addSynchronization(s);
        } else {
            super.addSynchronization(s);
        }
    }
}

