/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import org.apache.fulcrum.security.PermissionManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractPermissionManagerTest
extends BaseUnit5Test {
    protected Permission permission;
    protected PermissionManager permissionManager;
    protected SecurityService securityService;

    @Test
    public void testGetPermissionInstance() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance();
        Assertions.assertNotNull((Object)this.permission);
        Assertions.assertTrue((this.permission.getName() == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetPermissionInstanceString() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CAN_TREAT_ANIMALS");
        Assertions.assertEquals((Object)"can_treat_animals", (Object)this.permission.getName());
    }

    @Test
    public void testGetPermissionByName() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_KENNEL");
        this.permissionManager.addPermission(this.permission);
        Permission permission2 = this.permissionManager.getPermissionByName("CLEAN_KENNEL");
        Assertions.assertEquals((Object)this.permission.getName(), (Object)permission2.getName());
    }

    @Test
    public void testGetPermissionById() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("ADMINSTER_DRUGS");
        this.permissionManager.addPermission(this.permission);
        Permission permission2 = this.permissionManager.getPermissionById(this.permission.getId());
        Assertions.assertEquals((Object)this.permission.getName(), (Object)permission2.getName());
    }

    @Test
    public void testGetAllPermissions() throws Exception {
        int size = this.permissionManager.getAllPermissions().size();
        this.permission = this.permissionManager.getPermissionInstance("WALK_DOGS");
        this.permissionManager.addPermission(this.permission);
        PermissionSet permissionSet = this.permissionManager.getAllPermissions();
        Assertions.assertEquals((int)(size + 1), (int)permissionSet.size());
    }

    @Test
    public void testRenamePermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_FRONT_OFFICE");
        this.permissionManager.addPermission(this.permission);
        int size = this.permissionManager.getAllPermissions().size();
        this.permissionManager.renamePermission(this.permission, "CLEAN_GROOMING_ROOM");
        Permission permission2 = this.permissionManager.getPermissionById(this.permission.getId());
        Assertions.assertEquals((Object)"CLEAN_GROOMING_ROOM".toLowerCase(), (Object)permission2.getName());
        Assertions.assertEquals((int)size, (int)this.permissionManager.getAllPermissions().size());
    }

    @Test
    public void testRemovePermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_CAT_HOUSE");
        this.permissionManager.addPermission(this.permission);
        this.permissionManager.removePermission(this.permission);
        try {
            this.permission = this.permissionManager.getPermissionById(this.permission.getId());
            Assertions.fail((String)"Should have thrown UnknownEntityException");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    @Test
    public void testAddPermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("CLEAN_BIG_KENNEL");
        Assertions.assertNull((Object)this.permission.getId());
        this.permissionManager.addPermission(this.permission);
        Assertions.assertNotNull((Object)this.permission.getId());
        this.permission = this.permissionManager.getPermissionById(this.permission.getId());
        Assertions.assertNotNull((Object)this.permission);
    }

    @Test
    public void testGetPermissionsRole() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("GREET_PEOPLE");
        this.permissionManager.addPermission(this.permission);
        Permission permission2 = this.permissionManager.getPermissionInstance("ADMINISTER_DRUGS");
        this.permissionManager.addPermission(permission2);
        Role role = this.securityService.getRoleManager().getRoleInstance("VET_TECH");
        this.securityService.getRoleManager().addRole(role);
        ((DynamicModelManager)this.securityService.getModelManager()).grant(role, this.permission);
        PermissionSet permissions = ((DynamicRole)role).getPermissions();
        Assertions.assertEquals((int)1, (int)permissions.size());
        Assertions.assertTrue((boolean)permissions.contains((Object)this.permission));
        Assertions.assertFalse((boolean)permissions.contains((Object)permission2));
    }

    @Test
    public void testCheckExistsPermission() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("OPEN_OFFICE");
        this.permissionManager.addPermission(this.permission);
        Assertions.assertTrue((boolean)this.permissionManager.checkExists(this.permission));
        Permission permission2 = this.permissionManager.getPermissionInstance("CLOSE_OFFICE");
        Assertions.assertFalse((boolean)this.permissionManager.checkExists(permission2));
    }

    @Test
    public void testCheckExistsPermissionWithString() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("OPEN_OFFICE2");
        this.permissionManager.addPermission(this.permission);
        Assertions.assertTrue((boolean)this.permissionManager.checkExists(this.permission.getName()));
        Permission permission2 = this.permissionManager.getPermissionInstance("CLOSE_OFFICE2");
        Assertions.assertFalse((boolean)this.permissionManager.checkExists(permission2.getName()));
    }

    @Test
    public void testAddPermissionTwiceFails() throws Exception {
        this.permission = this.permissionManager.getPermissionInstance("EATLUNCH");
        this.permissionManager.addPermission(this.permission);
        Assertions.assertTrue((boolean)this.permissionManager.checkExists(this.permission.getName()));
        Permission permission2 = this.permissionManager.getPermissionInstance("EATLUNCH");
        try {
            this.permissionManager.addPermission(permission2);
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }
}

