/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.role;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.fulcrum.yaafi.framework.role.RoleEntry;
import org.apache.fulcrum.yaafi.framework.util.ToStringBuilder;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class RoleEntryImpl
implements RoleEntry {
    private String name;
    private String implementationClazzName;
    private String shorthand;
    private boolean isEarlyInit;
    private String description;
    private String componentType;
    private String componentFlavour;
    private boolean hasDynamicProxy;
    private ArrayList<String> interceptorList;
    private String logCategory;

    public RoleEntryImpl(String name, String defaultClass, String shorthand, boolean earlyInit, String description, String componentType, String componentFlavour, boolean hasProxy, ArrayList<String> interceptorList, String logCategory) {
        Validate.notEmpty(name, "name");
        Validate.notEmpty(defaultClass, "defaultClass");
        Validate.notEmpty(shorthand, "shorthand");
        Validate.notEmpty(componentType, "componentType");
        Validate.notEmpty(componentFlavour, "componentFlavour");
        Validate.notNull(interceptorList, "interceptorList");
        Validate.notEmpty(logCategory, "logCategory");
        this.name = name;
        this.implementationClazzName = defaultClass;
        this.shorthand = shorthand;
        this.isEarlyInit = earlyInit;
        this.description = description;
        this.componentType = componentType;
        this.componentFlavour = componentFlavour;
        this.hasDynamicProxy = hasProxy;
        this.interceptorList = interceptorList;
        this.logCategory = logCategory;
    }

    @Override
    public String getComponentType() {
        return this.componentType;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getImplementationClazzName() {
        return this.implementationClazzName;
    }

    @Override
    public boolean isEarlyInit() {
        return this.isEarlyInit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShorthand() {
        return this.shorthand;
    }

    @Override
    public String getComponentFlavour() {
        return this.componentFlavour;
    }

    @Override
    public boolean hasDynamicProxy() {
        return this.hasDynamicProxy;
    }

    @Override
    public void setHasDynamicProxy(boolean hasProxy) {
        this.hasDynamicProxy = hasProxy;
    }

    public boolean hasInterceptor(String interceptorName) {
        String currInterceptorName2 = null;
        for (String currInterceptorName2 : this.interceptorList) {
            if (!currInterceptorName2.equals(interceptorName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addInterceptors(Collection<?> collection) {
        String currInterceptorName2 = null;
        for (String currInterceptorName2 : collection) {
            if (this.hasInterceptor(currInterceptorName2)) continue;
            this.interceptorList.add(currInterceptorName2);
        }
    }

    @Override
    public String[] getInterceptorList() {
        return this.interceptorList.toArray(new String[this.interceptorList.size()]);
    }

    @Override
    public String getLogCategory() {
        return this.logCategory;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        toStringBuilder.append("name", this.name);
        toStringBuilder.append("shorthand", this.shorthand);
        toStringBuilder.append("implementationClazzName", this.implementationClazzName);
        toStringBuilder.append("isEarlyInit", this.isEarlyInit);
        toStringBuilder.append("hasDynamicProxy", this.hasDynamicProxy);
        toStringBuilder.append("componentType", this.componentType);
        toStringBuilder.append("componentFlavour", this.componentFlavour);
        toStringBuilder.append("interceptorList", this.interceptorList);
        toStringBuilder.append("logCategory", this.logCategory);
        toStringBuilder.append("description", this.description);
        return toStringBuilder.toString();
    }
}

