/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.ShiftingRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public class ShiftAllRule
extends ShiftingRule {
    private TrabalRuleItem errorBoundaryItem;

    public ShiftAllRule(TrabalLearner parentAlgorithm, TextRulerTarget target, TrabalAnnotation annotation, TrabalAnnotation targetAnnotation, AnnotationErrorType errorType) {
        super(parentAlgorithm, target, annotation, targetAnnotation, errorType);
    }

    public ShiftAllRule(ShiftAllRule copyFrom) {
        super(copyFrom);
        this.errorBoundaryItem = copyFrom.errorBoundaryItem;
    }

    @Override
    public void compileRuleString() {
        Object conditions;
        this.ruleString = "";
        boolean shiftToLeft = this.errorType == AnnotationErrorType.SHIFTING_LEFT;
        boolean frontItemInBorders = this.frontBoundaryItem.getAnnotation().getBegin() == this.targetAnnotation.getBegin();
        boolean rearItemInBorders = this.rearBoundaryItem.getAnnotation().getEnd() == this.targetAnnotation.getEnd();
        Object before = this.parseConditions(ConditionType.BEFORE);
        if (((String)before).length() > 0) {
            before = "{" + (String)before + "}";
        }
        if (((String)(conditions = this.parseConditions(this.conditionTypes))).length() > 0) {
            conditions = (String)conditions + " ";
        }
        String mark = ((TrabalLearner)this.algorithm).getEnableFeatures() ? "-> CREATE(" + this.targetAnnotation.getType().getShortName() + this.parseFeatures() + ")" : "-> MARK(" + this.targetAnnotation.getType().getShortName() + ")";
        String action = "{" + (String)conditions + mark + "}";
        if (this.errorBoundaryItem == null) {
            this.compileWithoutErrorRuleItem(frontItemInBorders, rearItemInBorders, (String)before, action);
        } else {
            Object after = this.parseConditions(ConditionType.AFTER);
            if (((String)after).length() > 0) {
                after = "{" + (String)after + "}";
            }
            String unmark = String.valueOf(this.errorBoundaryItem) + (frontItemInBorders ? "" : " ANY") + "{STARTSWITH(" + this.annotation.getType().getShortName() + ") -> UNMARK(" + this.annotation.getType().getShortName() + ", true)}";
            if (shiftToLeft) {
                this.compileShiftToLeft(frontItemInBorders, rearItemInBorders, (String)before, (String)after, action, unmark);
            } else {
                this.compileShiftToRight(frontItemInBorders, rearItemInBorders, (String)before, (String)after, action, unmark);
            }
        }
        this.setNeedsCompile(false);
    }

    private void compileShiftToLeft(boolean frontItemInBorders, boolean rearItemInBorders, String before, String after, String action, String unmark) {
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + String.valueOf(this.frontBoundaryItem) + after + " " : this.ruleString + String.valueOf(this.frontBoundaryItem) + after + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + String.valueOf(this.errorBoundaryItem) + ")} " + unmark + " ANY*{-PARTOF(" + String.valueOf(this.rearBoundaryItem) + ")}";
        this.ruleString = rearItemInBorders ? this.ruleString + " " + String.valueOf(this.rearBoundaryItem) + before + ")" + action + ";" : this.ruleString + ")" + action + " " + String.valueOf(this.rearBoundaryItem) + before + ";";
    }

    private void compileShiftToRight(boolean frontItemInBorders, boolean rearItemInBorders, String before, String after, String action, String unmark) {
        this.ruleString = this.ruleString + unmark + " ANY*{-PARTOF(" + String.valueOf(this.frontBoundaryItem) + ")} ";
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + String.valueOf(this.frontBoundaryItem) + after + " " : this.ruleString + String.valueOf(this.frontBoundaryItem) + after + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + String.valueOf(this.rearBoundaryItem) + ")}";
        this.ruleString = rearItemInBorders ? this.ruleString + " " + String.valueOf(this.rearBoundaryItem) + before + ")" + action + ";" : this.ruleString + ")" + action + " " + String.valueOf(this.rearBoundaryItem) + before + ";";
    }

    private void compileWithoutErrorRuleItem(boolean frontItemInBorders, boolean rearItemInBorders, String before, String action) {
        Object after = this.parseConditions(ConditionType.AFTER);
        if (((String)after).length() > 0) {
            after = ", " + (String)after;
        }
        String unmark = "{STARTSWITH(" + this.annotation.getType().getShortName() + ")" + (String)after + " -> UNMARK(" + this.annotation.getType().getShortName() + ", true)}";
        this.ruleString = frontItemInBorders ? this.ruleString + "(" + String.valueOf(this.frontBoundaryItem) + unmark + " " : this.ruleString + String.valueOf(this.frontBoundaryItem) + unmark + " (";
        this.ruleString = this.ruleString + "ANY*{-PARTOF(" + String.valueOf(this.rearBoundaryItem) + ")}";
        this.ruleString = rearItemInBorders ? this.ruleString + " " + String.valueOf(this.rearBoundaryItem) + before + ")" + action + ";" : this.ruleString + ")" + action + " " + String.valueOf(this.rearBoundaryItem) + before + ";";
    }

    @Override
    public boolean contains(TrabalAnnotation target) {
        if (target != null) {
            if (this.annotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.targetAnnotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.frontBoundaryItem != null && this.frontBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            if (this.errorBoundaryItem != null && this.errorBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            if (this.rearBoundaryItem != null && this.rearBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            for (Condition each : this.getConditions()) {
                if (!each.getItem().getAnnotation().getType().getShortName().equals(target.getType().getShortName())) continue;
                return true;
            }
        }
        return false;
    }

    public void setErrorBoundaryItem(TrabalRuleItem errorBoundaryItem) {
        this.errorBoundaryItem = errorBoundaryItem;
    }

    @Override
    public TrabalRule copy() {
        return new ShiftAllRule(this);
    }
}

