/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class DynamicAnchoringAction
extends AbstractRutaAction {
    private final IBooleanExpression active;
    private final INumberExpression panelty;
    private final INumberExpression factor;

    public DynamicAnchoringAction(IBooleanExpression active, INumberExpression panelty, INumberExpression factor) {
        this.active = active;
        this.panelty = panelty;
        this.factor = factor;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        context.getElement();
        boolean activated = this.active.getBooleanValue(context, stream);
        stream.setDynamicAnchoring(activated);
        if (this.panelty != null) {
            double p = this.panelty.getDoubleValue(context, stream);
            stream.setIndexPenalty(p);
        }
        if (this.factor != null) {
            double f = this.factor.getDoubleValue(context, stream);
            stream.setAnchoringFactor(f);
        }
    }

    public IBooleanExpression getActive() {
        return this.active;
    }

    public INumberExpression getPanelty() {
        return this.panelty;
    }

    public INumberExpression getFactor() {
        return this.factor;
    }
}

