/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.uima.resource.RelativePathResolver;

public class RelativePathResolver_impl
implements RelativePathResolver {
    @Deprecated(since="3.6.0")
    private List<String> mDataPath;
    private List<URL> mBaseUrls;
    private ClassLoader mClassLoader;

    public RelativePathResolver_impl() {
        this(MethodHandles.lookup().lookupClass().getClassLoader());
    }

    public RelativePathResolver_impl(ClassLoader aClassLoader) {
        String dataPath = null;
        try {
            dataPath = System.getProperty("uima.datapath");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (dataPath == null) {
            try {
                dataPath = System.getProperty("user.dir");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (dataPath == null) {
            dataPath = "";
        }
        try {
            this.setDataPath(dataPath);
        }
        catch (MalformedURLException e) {
            this.mDataPath = null;
            this.mBaseUrls = null;
        }
        this.mClassLoader = aClassLoader;
    }

    @Override
    @Deprecated
    public String getDataPath() {
        if (this.mDataPath == null) {
            return "";
        }
        String pathSepChar = System.getProperty("path.separator");
        return this.mDataPath.stream().collect(Collectors.joining(pathSepChar));
    }

    @Override
    @Deprecated
    public List<String> getDataPathElements() {
        if (this.mDataPath == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mDataPath);
    }

    @Override
    public List<URL> getDataPathUrls() {
        if (this.mBaseUrls == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mBaseUrls);
    }

    @Override
    public void setDataPathElements(File ... aElements) throws MalformedURLException {
        if (aElements == null) {
            this.mDataPath = null;
            this.mBaseUrls = null;
            return;
        }
        ArrayList<URL> baseUrls = new ArrayList<URL>(aElements.length);
        for (File path : aElements) {
            baseUrls.add(path.toURL());
        }
        this.mDataPath = Arrays.stream(aElements).map(File::getPath).map(s -> s.replace(File.separator, "/")).toList();
        this.mBaseUrls = baseUrls;
    }

    @Override
    public void setDataPathElements(String ... aElements) throws MalformedURLException {
        if (aElements == null) {
            this.mDataPath = null;
            this.mBaseUrls = null;
            return;
        }
        ArrayList<String> dataPath = new ArrayList<String>(aElements.length);
        ArrayList<URL> baseUrls = new ArrayList<URL>(aElements.length);
        for (String element : aElements) {
            try {
                URL url = new URL(element);
                baseUrls.add(url);
                String protocol = url.getProtocol();
                if (protocol == null || !protocol.equalsIgnoreCase("file")) continue;
                dataPath.add(new File(URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8)).getPath());
            }
            catch (MalformedURLException e) {
                baseUrls.add(new File(element).toURL());
                dataPath.add(element);
            }
        }
        this.mDataPath = dataPath;
        this.mBaseUrls = baseUrls;
    }

    @Override
    public void setDataPathElements(URL ... aElements) {
        if (aElements == null) {
            this.mDataPath = null;
            this.mBaseUrls = null;
            return;
        }
        ArrayList<String> dataPath = new ArrayList<String>(aElements.length);
        for (URL url : aElements) {
            String protocol = url.getProtocol();
            if (protocol == null || !protocol.equalsIgnoreCase("file")) continue;
            dataPath.add(new File(URLDecoder.decode(url.getPath(), StandardCharsets.UTF_8)).getPath());
        }
        this.mDataPath = dataPath;
        this.mBaseUrls = Arrays.asList(aElements);
    }

    @Override
    @Deprecated
    public void setDataPath(String aPath) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        ArrayList<String> paths = new ArrayList<String>();
        String pathSepChar = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(aPath, pathSepChar);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            paths.add(tok);
            urls.add(new File(tok).toURL());
        }
        this.mDataPath = paths;
        this.mBaseUrls = urls;
    }

    @Override
    public URL resolveRelativePath(String aPathOrUrl) {
        try {
            URL url = new URL(aPathOrUrl);
            return this.resolveRelativePath(url);
        }
        catch (MalformedURLException url) {
            for (URL baseUrl : this.mBaseUrls) {
                try {
                    URL absUrl = new URL(baseUrl, aPathOrUrl);
                    if (!this.fileExistsAtUrl(absUrl)) continue;
                    return absUrl;
                }
                catch (MalformedURLException malformedURLException) {
                }
            }
            URL absURL = null;
            if (this.mClassLoader != null) {
                absURL = this.mClassLoader.getResource(aPathOrUrl);
            }
            if (absURL == null) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                absURL = tccl.getResource(aPathOrUrl);
            }
            if (absURL == null && this.mClassLoader == null) {
                absURL = ClassLoader.getSystemClassLoader().getResource(aPathOrUrl);
            }
            return absURL;
        }
    }

    @Override
    @Deprecated
    public URL resolveRelativePath(URL aUrl) {
        for (URL baseUrl : this.mBaseUrls) {
            try {
                URL absUrl = new URL(baseUrl, aUrl.toString());
                if (!this.fileExistsAtUrl(absUrl)) continue;
                return absUrl;
            }
            catch (MalformedURLException absUrl) {
            }
        }
        if (aUrl.getPath().startsWith("/") && this.fileExistsAtUrl(aUrl)) {
            return aUrl;
        }
        String f = aUrl.getFile();
        URL absURL = null;
        if (this.mClassLoader != null) {
            absURL = this.mClassLoader.getResource(f);
        }
        if (absURL == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            absURL = tccl.getResource(f);
        }
        if (absURL == null && this.mClassLoader == null) {
            absURL = ClassLoader.getSystemClassLoader().getResource(f);
        }
        return absURL;
    }

    @Override
    public void setPathResolverClassLoader(ClassLoader aClassLoader) {
        this.mClassLoader = aClassLoader;
    }

    protected boolean fileExistsAtUrl(URL aUrl) {
        boolean bl;
        block8: {
            URLConnection connection = aUrl.openConnection();
            connection.setDefaultUseCaches(false);
            InputStream testStream = connection.getInputStream();
            try {
                bl = true;
                if (testStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (testStream != null) {
                        try {
                            testStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            testStream.close();
        }
        return bl;
    }

    @Deprecated
    protected URL[] getBaseUrls() {
        return (URL[])this.mBaseUrls.toArray(URL[]::new);
    }
}

