/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import org.apache.karaf.cellar.core.Dispatcher;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventConsumer;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicConsumer<E extends Event>
implements EventConsumer<E>,
MessageListener<E> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(TopicConsumer.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.topic.consumer";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.topic.consumer");
    private String registrationId;
    private HazelcastInstance instance;
    private ITopic topic;
    private Dispatcher dispatcher;
    private Node node;
    private ConfigurationAdmin configurationAdmin;
    private boolean isConsuming;

    public void init() {
        if (this.topic == null) {
            this.topic = this.instance.getTopic("org.apache.karaf.cellar.event.topic");
        }
        this.start();
    }

    public void destroy() {
        this.stop();
    }

    public void consume(E event) {
        if ((event.getDestination() == null || event.getDestination().contains(this.node)) && (this.getSwitch().getStatus().equals((Object)SwitchStatus.ON) || event.getForce().booleanValue())) {
            this.dispatcher.dispatch(event);
        } else if (this.eventSwitch.getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR HAZELCAST: {} switch is OFF, cluster event is not consumed", (Object)SWITCH_ID);
        }
    }

    public void start() {
        this.isConsuming = true;
        if (this.topic != null) {
            this.registrationId = this.topic.addMessageListener((MessageListener)this);
        } else {
            this.topic = this.instance.getTopic("org.apache.karaf.cellar.event.topic");
            this.registrationId = this.topic.addMessageListener((MessageListener)this);
        }
    }

    public void stop() {
        this.isConsuming = false;
        if (this.topic != null) {
            this.topic.removeMessageListener(this.registrationId);
        }
    }

    public Boolean isConsuming() {
        return this.isConsuming;
    }

    public void onMessage(Message<E> message) {
        this.consume((Event)message.getMessageObject());
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public ITopic getTopic() {
        return this.topic;
    }

    public void setTopic(ITopic topic) {
        this.topic = topic;
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                Boolean status = new Boolean((String)configuration.getProperties().get("consumer"));
                if (status.booleanValue()) {
                    this.eventSwitch.turnOn();
                } else {
                    this.eventSwitch.turnOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

