/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="unomi", name="action-view", description="This will display a single action deployed in the Apache Unomi Context Server")
@Service
public class ActionView
implements Action {
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="actionId", description="The identifier for the action", required=true, multiValued=false)
    String actionTypeIdentifier;

    public Object execute() throws Exception {
        ActionType actionType = this.definitionsService.getActionType(this.actionTypeIdentifier);
        if (actionType == null) {
            System.out.println("Couldn't find an action with id=" + this.actionTypeIdentifier);
            return null;
        }
        String jsonRule = CustomObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)actionType);
        System.out.println(jsonRule);
        return null;
    }
}

