
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * Add two CDATASections containing "]]>" perform normalization with split-cdata-sections=true.
 * Should result in two warnings and at least 4 nodes.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-normalizeDocument</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-split-cdata-sections">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#parameter-split-cdata-sections</a>
*/
public final class documentnormalizedocument08 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentnormalizedocument08(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "barfoo", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Element elem;
      DOMConfiguration domConfig;
      NodeList elemList;
      CDATASection newChild;
      Node oldChild;
      Node retval;
      org.w3c.domts.DOMErrorMonitor errorMonitor = new org.w3c.domts.DOMErrorMonitor();
      
      java.util.List errors = new java.util.ArrayList();
      
      DOMError error;
      int length;
      NodeList childNodes;
      String type;
      int splittedCount = 0;
      int severity;
      doc = (Document) load("barfoo", true);
      elemList = doc.getElementsByTagName("p");
      elem = (Element) elemList.item(0);
      newChild = doc.createCDATASection("this is not ]]> good");
      oldChild = elem.getFirstChild();
      retval = elem.replaceChild(newChild, oldChild);
      newChild = doc.createCDATASection("this is not ]]> good");
      retval = elem.appendChild(newChild);
      domConfig = doc.getDomConfig();
      domConfig.setParameter("split-cdata-sections", Boolean.TRUE);
      domConfig.setParameter("error-handler", ((Object) /*DOMErrorMonitor */errorMonitor));
      doc.normalizeDocument();
      errors = errorMonitor.getAllErrors();
for (int indexN100A3 = 0; indexN100A3 < errors.size(); indexN100A3++) {
          error = (DOMError) errors.get(indexN100A3);
    type = error.getType();
      severity = (int) error.getSeverity();
      
      if (equals("cdata-sections-splitted", type)) {
          splittedCount += 1;
      } else {
          assertEquals("anyOthersShouldBeWarnings", 1, severity);
      }
        
      }
      assertEquals("twoSplittedWarning", 2, splittedCount);
      elemList = doc.getElementsByTagName("p");
      elem = (Element) elemList.item(0);
      childNodes = elem.getChildNodes();
      length = (int) childNodes.getLength();
      assertTrue("atLeast4ChildNodes", (length > 3));
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentnormalizedocument08";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentnormalizedocument08.class, args);
   }
}

