/* Author: Wietse Venema <wietse@wzv.win.tue.nl> */

#include "sys_defs.h"

#include <sys/types.h>
#include <sys/time.h>
#include <utmpx.h>
#include <string.h>
#include <syslog.h>
#include <sac.h>

/* utmpx_init - update utmp and wtmp before login */

utmpx_init(line, user, tag)
char   *line;
char   *user;
char   *tag;
{
    struct utmpx utx;

    memset((char *) &utx, 0, sizeof(utx));
    strncpy(utx.ut_user, user, sizeof(utx.ut_user));
    strncpy(utx.ut_line, line, sizeof(utx.ut_line));
    utx.ut_pid = getpid();
    utx.ut_type = LOGIN_PROCESS;
    gettimeofday(&(utx.ut_tv));
    utx.ut_id[0] = tag[0];
    utx.ut_id[1] = tag[1];
    utx.ut_id[2] = SC_WILDC;
    utx.ut_id[3] = SC_WILDC;
    if (makeutx(&utx) == 0)
	return (-1);
    pututxline(&utx);
    updwtmpx(WTMPX_FILE, &utx);
    endutxent();
    return (0);
}
