typedef struct hash_bucket {
  char * str;
  void * value;
  struct hash_bucket * next;
} hbucket;

typedef struct hash_table {
  size_t size;
  hbucket ** bucket;
} htable;

size_t num_entries(htable * ht);
int element_at_index(htable * ht, size_t idx, char ** str, void ** v);
htable * create_hash_table(size_t size);
void add_hash_string(htable * ht, char * str, void * value);
unsigned char get_value(htable * ht, char * str, void ** value);
xfmisc_t * make_linked_list(htable * ht);
void clean_table(htable * ht);
