/*
 * Quick n dirty functions to do linked list stuff.
 * Copyright 1998 Nat Friedman, Massachusetts Institute of Technology
 * <ndf@mit.edu>
 *
 * Small modifications to adapt list.c to xferstats source are Copyright 1998
 * Phil Schwan <pschwan@cmu.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "xferstats.h"

list_t *
list_new(void)
{
  /* An empty list. */
  return NULL;
} /* list_new */


void
list_add_item_head(list_t ** list, void * item)
{
  list_t * l;

  /* Allocate a new link for this item. */
  MY_MALLOC(l, sizeof(list_t));
  l->item = item;

  /* Put it at the head of the list */
  l->next = *list;
  *list = l;
  
} /* list_add_item_head */


void
list_add_item_tail(list_t ** list, void * item)
{
  list_t * l, * curr;

  /* Allocate a new link for this item. */
  MY_MALLOC(l, sizeof(list_t));
  l->item = item;
  l->next = NULL;

  /* If it's an empty list, then this new item becomes the entire list */
  if (*list == NULL)
    {
      *list = l;
      return;
    }

  /* Walk to the end of the list */
  curr = *list;
  while (curr->next != NULL)
    curr = curr->next;

  /* Add the item to the end */
  curr->next = l;

} /* list_add_item_tail */


void
list_add_item(list_t ** list, void * item)
{
  list_add_item_head(list, item);
} /* list_add_item */


int 
list_remove_item(list_t ** list, void * item)
{
  list_t * l, * prev;

  if (list == NULL)
    {
      fprintf(stderr, "list_remove_item: NULL list!");
      return -1;
    }

  /* Walk the list until we hit the end or we find the object. */
  prev = NULL;
  l = *list;
  while ((l != NULL) && (l->item != item))
    {
      prev = l;
      l = l->next;
    }

  if (l == NULL)
    {
#ifdef DEBUG
      fprintf(stderr, "list_remove_item: Item not found in list!");
#endif
    }

  if (prev != NULL)
    prev->next = l->next;
  else
    *list = l->next;

  free(l);

  return 0;
} /* list_remove_item */


/* This will destroy a whole list, but not the items contained therein */
void
list_destroy(list_t ** list)
{
  list_t * l, * next;

  l = *list;

  /* Destroy the chain behind us as we go. */
  while (l != NULL)
    {
      next = l->next;

      free(l);

      l = next;
    }

  *list = NULL;
} /* list_destroy */
