#
# $Id: Makefile.sol,v 1.2 1997/01/16 08:35:26 sob Exp $
#
#
CC       = cc
IFLAGS   = -I.. -I../support
LFLAGS   = -L../support
CFLAGS   = -g -DDEBUG ${IFLAGS} ${LFLAGS}
LIBES    = -lsupport -lsocket -lnsl -lgen
LIBC     = /lib/libc.a
LINTFLAGS=	
LKERB    = -lauth -lckrb -lkrb -ldes
MKDEP    = makedepend

SRCS   = ftpd.c ftpcmd.c glob.c logwtmp.c popen.c vers.c access.c extensions.c \
	realpath.c acl.c private.c authenticate.c conversions.c hostacc.c \
	sigfix.c
OBJS   = ftpd.o ftpcmd.o glob.o logwtmp.o popen.o vers.o access.o extensions.o \
	realpath.o acl.o private.o authenticate.o conversions.o hostacc.o \
	sigfix.o

all: ftpd ftpcount ftpshut ckconfig

ftpcount:	ftpcount.c pathnames.h
	${CC} ${CFLAGS} -o $@ ftpcount.c vers.o ${LIBES} 

ftpshut:    ftpshut.c pathnames.h
	${CC} ${CFLAGS} -o $@ ftpshut.c vers.o ${LIBES}

ckconfig:   ckconfig.c
	${CC} ${CFLAGS} -o $@ ckconfig.c

ftpd: ${OBJS} ${LIBC}
	${CC} ${CFLAGS} -o $@ ${OBJS} ${LIBES}

index:	index.o ${LIBC}
	${CC} -Bstatic -o $@ index.o

vers.o: ftpd.c ftpcmd.y
	sh newvers.sh
	${CC} ${CFLAGS} -c vers.c

clean:
	rm -f ${OBJS} ftpd ftpcmd.c ftpshut ftpshut.o ftpcount ftpcount.o
	rm -f core index index.o

cleandir: clean
	rm -f tags .depend

depend: ${SRCS}
	${MKDEP} ${CFLAGS} ${SRCS}

lint: ${SRCS}
	lint ${CFLAGS} ${LINTFLAGS} ${SRCS}

tags: ${SRCS}
	ctags ${SRCS}
