#
# Makefile for Solaris 2.X (SunOS 5.X)
#
# $Id: Makefile.sol,v 1.6 1997/08/12 03:45:00 sob Exp sob $
#
CC     = cc
AR     = ar cq
RANLIB = ranlib
LIBC   = /lib/libc.a
IFLAGS = -DSOLARIS2
LFLAGS = 
CFLAGS = -O ${IFLAGS} ${LFLAGS}
#
SRCS   = fnmatch.c strcasestr.c strsep.c authuser.c snprintf.c
OBJS   = fnmatch.o strcasestr.o strsep.o authuser.o snprintf.o

all: $(OBJS)
	-rm -f libsupport.a
	${AR} libsupport.a $(OBJS)
	${RANLIB} libsupport.a

clean:
	-rm -f *.o libsupport.a

fnmatch.o: fnmatch.c
	${CC} ${CFLAGS} -c fnmatch.c

strerror.o: strerror.c
	${CC} ${CFLAGS} -c strerror.c

strdup.o: strdup.c
	${CC} ${CFLAGS} -c strdup.c

strcasestr.o: strcasestr.c
	${CC} ${CFLAGS} -c strcasestr.c

strsep.o: strsep.c
	${CC} ${CFLAGS} -c strsep.c

authuser.o: authuser.c
	${CC} ${CFLAGS} -c authuser.c

snprintf.o: snprintf.c
	${CC} ${CFLAGS} -c snprintf.c

