/* 
 * Top level config file... you'll probably not need to modify any of this.
 * $Id: config.h,v 1.11 1998/07/06 09:16:39 sob BETA-18 sob $
 * In the future, a lot more definable features will be here (and this
 * will all make sense...)
 */

/*
 * allow "upload" keyword in ftpaccess
 */

#define UPLOAD

/*
 * allow "overwrite" keyword in ftpaccess.
 */

#define OVERWRITE

/*
 * allow "allow/deny" for individual users.
 */

#define HOST_ACCESS

/*
 * log failed login attempts
 */

#define LOG_FAILED

/*
 * log login attempts that fail because of class connection
 * limits.  Busy servers may want to prevent this logging
 * since it can fill up the log file and put a high load on
 * syslog.
 */
#define LOG_TOOMANY

/*
 * allow use of private file.  (for site group and site gpass)
 */

#undef NO_PRIVATE

/*
 * Try once more on failed DNS lookups (to allow far away connections 
 * which might resolve slowly)
 */

#define	DNS_TRYAGAIN

/*
 * ANON_ONLY 
 * Permit only anonymous logins... disables all other type
 * See FIXES-2.4-HOBBIT for more information on this option.
 */

#undef ANON_ONLY

/*
 * PARANOID
 * Disable "questionable" functions
 * See FIXES-2.4-HOBBIT for more information on this option.
 */

#undef PARANOID

/*
 * SKEY
 * Add SKEY support -- REQUIRES SKEY libraries
 * See FIXES-2.4-HOBBIT for more information on this option.
 */

#undef SKEY

/*
 * ALTERNATE_CD
 * Causes "cd ~" to return the chroot-relative directory instead of the
 * real directory.
 */
#define ALTERNATE_CD

/*
 * UNRESTRICTED_CHMOD
 * If defined, any valid value for the mode will be accepted.
 * Otherwise, only values between 0 and 777 are accepted.
 */
#undef UNRESTRICTED_CHMOD

/*
 * NO_PRIVATE
 * Define this if you don't want to use the private authentication databases.
 */
#undef NO_PRIVATE

/*
 * DAEMON
 * If ftpd called with -D then run as a standalone daemon listing on the
 * ftp port.   This can speed up ftpd response as all ftpd then needs to
 * do is fork off a copy to handle an incoming request.  Under inetd 
 * a new copy has to be opened and exec'd.
 */
#define DAEMON

/*
 * MAX_BACKLOG
 * Only used in DAEMON mode.
 * This is second parameter to listen.  It defines the number of incoming
 * processes to allow to backlog, prior to being accept() processing them,
 * before rejecting.
 */
#define MAX_BACKLOG 100

/*
 * MAPPING_CHDIR
 * Keep track of the path the user has chdir'd into and respond with
 * that to pwd commands.  This is to avoid having the absolue disk
 * path returned.  This helps avoid returning dirs like '.1/fred'
 * when lots of disks make up the ftp area.
 */

#define MAPPING_CHDIR

/*
 * THROUGHPUT
 * Keep track of total throughput for the user and limit if required.
 */

#define THROUGHPUT

/*
 * TRANSFER_COUNT
 * Keep track of total bytes for statistics.
 */

#define TRANSFER_COUNT

/*
 * TRANSFER_LIMIT
 * Limit file and bytes transferred in a session.
 */

#ifdef TRANSFER_COUNT
#define TRANSFER_LIMIT
#else
#undef TRANSFER_LIMIT
#endif

/*
 * NO_SUCKING_NEWLINES
 * Don't suppress some extra blank lines on messages and banners.
 */

#undef NO_SUCKING_NEWLINES

/*
 * HELP_CRACKERS
 * Define this to help crackers break into your system by letting them
 * figure out which user names exist to guess passwords on.
 */

#undef HELP_CRACKERS

/*
 * VERBOSE_ERROR_LOGING
 * Log all problems with USER and PASS as well as all rejected commands
 * and denied uploads/downloads.
 */

#define VERBOSE_ERROR_LOGING
