# Makefile for Solaris 2.X (SunOS 5.X)
# $Id: Makefile.sol,v 1.8 1998/07/06 09:13:07 sob BETA-18 sob $
#
#
CC       = cc
IFLAGS   = -I.. -I../support
LFLAGS   = -L../support
CFLAGS   = -g ${IFLAGS} ${LFLAGS}
LIBES    = -lsupport -lsocket -lnsl -lgen 
LIBC     = /lib/libc.a
LINTFLAGS=	
LKERB    = -lauth -lckrb -lkrb -ldes 
MKDEP    = makedepend

SRCS   = ftpd.c ftpcmd.c glob.c logwtmp.c popen.c vers.c access.c \
	 extensions.c \
	 realpath.c acl.c private.c authenticate.c conversions.c hostacc.c \
	 sigfix.c
OBJS   = ftpd.o ftpcmd.o glob.o logwtmp.o popen.o vers.o access.o \
	 extensions.o \
	 realpath.o acl.o private.o authenticate.o conversions.o hostacc.o \
	 sigfix.o

all: ftpd ftpcount ftpshut ckconfig

ftpcount:	ftpcount.c pathnames.h vers.o
	${CC} ${CFLAGS} -o $@ ftpcount.c vers.o ${LIBES} 

ftpshut:    ftpshut.c pathnames.h vers.o
	${CC} ${CFLAGS} -o $@ ftpshut.c vers.o ${LIBES}

ckconfig:   ckconfig.c
	${CC} ${CFLAGS} -o $@ ckconfig.c

ftpd: ${OBJS} ${LIBC}
	${CC} ${CFLAGS} -o $@ ${OBJS} ${LIBES}

index:	index.o ${LIBC}
	${CC} -Bstatic -o $@ index.o

vers.c: ftpcmd.c
	sh newvers.sh

clean:
	rm -f ${OBJS} ftpd ftpcmd.c ftpshut ftpshut.o ftpcount ftpcount.o
	rm -f core index index.o ckconfig ckconfig.o

cleandir: clean
	rm -f tags .depend

depend: ${SRCS}
	${MKDEP} ${CFLAGS} ${SRCS}

lint: ${SRCS}
	lint ${CFLAGS} ${LINTFLAGS} ${SRCS}

tags: ${SRCS}
	ctags ${SRCS}
