#
# Makefile for Solaris 2.X (SunOS 5.X)
#
# $Id: Makefile.sol,v 1.2 1996/01/22 07:42:16 sob Exp $
#
CC     = cc
AR     = ar cq
RANLIB = touch
LIBC   = /lib/libc.a
IFLAGS = 
LFLAGS = 
CFLAGS = -g -DDEBUG ${IFLAGS} ${LFLAGS}

SRCS   = fnmatch.c strcasestr.c strsep.c authuser.c vsnprintf.c
OBJS   = fnmatch.o strcasestr.o strsep.o authuser.o vsnprintf.o

all: $(OBJS)
	-rm -f libsupport.a
	${AR} libsupport.a $(OBJS)
	${RANLIB} libsupport.a

clean:
	-rm -f *.o libsupport.a

ftp.h:
	install -c -m 444 ftp.h /usr/include/arpa

paths.h:
	install -c -m 444 paths.h /usr/include

fnmatch.o: fnmatch.c
	${CC} ${CFLAGS} -c fnmatch.c

getusershell.o: getusershell.c
	${CC} ${CFLAGS} -c getusershell.c

strerror.o: strerror.c
	${CC} ${CFLAGS} -c strerror.c

strdup.o: strdup.c
	${CC} ${CFLAGS} -c strdup.c

strcasestr.o: strcasestr.c
	${CC} ${CFLAGS} -c strcasestr.c

strsep.o: strsep.c
	${CC} ${CFLAGS} -c strsep.c

authuser.o: authuser.c
	${CC} ${CFLAGS} -c authuser.c

ftw.o: ftw.c
	${CC} ${CFLAGS} -c ftw.c

vsnprintf.o: vsnprintf.c
	${CC} ${CFLAGS} -c vsnprintf.c

