/* 
 * Top level config file... you'll probably not need to modify any of this.
 * $Id: config.h,v 1.12 1999/02/26 16:04:13 sob RELEASE $
 * In the future, a lot more definable features will be here (and this
 * will all make sense...)
 */

/*
 * allow "upload" keyword in ftpaccess
 */

#define UPLOAD

/*
 * allow "overwrite" keyword in ftpaccess.
 */

#define OVERWRITE

/*
 * allow "allow/deny" for individual users.
 */

#define HOST_ACCESS

/*
 * log failed login attempts
 */

#define LOG_FAILED

/*
 * log login attempts that fail because of class connection
 * limits.  Busy servers may want to prevent this logging
 * since it can fill up the log file and put a high load on
 * syslog.
 */
#define LOG_TOOMANY

/*
 * allow use of private file.  (for site group and site gpass)
 * NO_PRIVATE
 * Define this if you don't want to use the private authentication databases.
 */

#undef NO_PRIVATE

/*
 * Try once more on failed DNS lookups (to allow far away connections 
 * which might resolve slowly)
 */

#define	DNS_TRYAGAIN

/*
 * ANON_ONLY 
 * Permit only anonymous logins... disables all other type
 * See FIXES-2.4-HOBBIT for more information on this option.
 */

#undef ANON_ONLY

/*
 * PARANOID
 * Disable "questionable" functions
 * See FIXES-2.4-HOBBIT for more information on this option.
 */

#undef PARANOID

/*
 * SKEY
 * Add SKEY support -- REQUIRES SKEY libraries
 * See FIXES-2.4-HOBBIT for more information on this option.
 */

#undef SKEY

/*
 * OPIE
 * One-time Passwords In Everything (OPIE)
 * Add OPIE support -- REQUIRES OPIE libraries
 */

#undef OPIE

/*
 * ALTERNATE_CD
 * Causes "cd ~" to return the chroot-relative directory instead of the
 * real directory.
 */
#define ALTERNATE_CD

/*
 * UNRESTRICTED_CHMOD
 * If defined, any valid value for the mode will be accepted.
 * Otherwise, only values between 0 and 777 are accepted.
 */
#undef UNRESTRICTED_CHMOD

/*
 * USE_RFC931
 * Define this if you want to use RFC 931 'authentication' - this improves
 * the logging at the cost of a possible slight delay in connection.
 */
#define USE_RFC931

/*
 * BUFFER_SIZE
 * You can specify the buffer size for binary transfers; the defaults
 * are often far too small for efficiency.
 */
#undef BUFFER_SIZE

/*
 * If you want to specify the syslog facility, you should modify CFLAGS in
 * the appropriate src/makefile/Makefile.*.
 */

/* If you want to set the paths where the configuration files, pids and logs
 * are stored, you should inspect src/pathnames.h and modify the appropriate
 * src/config/config.*.
 */

/*
 * DAEMON
 * If ftpd called with -D then run as a standalone daemon listing on the
 * ftp port.   This can speed up ftpd response as all ftpd then needs to
 * do is fork off a copy to handle an incoming request.  Under inetd 
 * a new copy has to be opened and exec'd.
 */
#define DAEMON

/*
 * MAX_BACKLOG
 * Only used in DAEMON mode.
 * This is second parameter to listen.  It defines the number of incoming
 * processes to allow to backlog, prior to being accept() processing them,
 * before rejecting.
 */
#define MAX_BACKLOG 100

/*
 * MAPPING_CHDIR
 * Keep track of the path the user has chdir'd into and respond with
 * that to pwd commands.  This is to avoid having the absolue disk
 * path returned.  This helps avoid returning dirs like '.1/fred'
 * when lots of disks make up the ftp area.
 */

#define MAPPING_CHDIR

/*
 * THROUGHPUT
 * Keep track of total throughput for the user and limit if required.
 */

#define THROUGHPUT

/*
 * TRANSFER_COUNT
 * Keep track of total bytes for statistics.
 */

#define TRANSFER_COUNT

/*
 * TRANSFER_LIMIT
 * Limit file and bytes transferred in a session.
 */

#ifdef TRANSFER_COUNT
#define TRANSFER_LIMIT
#else
#undef TRANSFER_LIMIT
#endif

/*
 * NO_SUCKING_NEWLINES
 * Don't suppress some extra blank lines on messages and banners.
 */

#undef NO_SUCKING_NEWLINES

/*
 * HELP_CRACKERS
 * Define this to help crackers break into your system by letting them
 * figure out which user names exist to guess passwords on.
 */

#undef HELP_CRACKERS

/*
 * VERBOSE_ERROR_LOGING
 * Log all problems with USER and PASS as well as all rejected commands
 * and denied uploads/downloads.
 */

#define VERBOSE_ERROR_LOGING

/*
 * IGNORE_NOOP
 * Undefine this to let NOOP reset the idle timeout.
 */

#define IGNORE_NOOP

/*
 * XFERLOG_REALPATH
 * Define this to log the real path rather than the chroot-relative path for
 * files named in the xferlog.
 */

#define XFERLOG_REALPATH

/*
 * CLOSED_VIRTUAL_SERVER
 * Undefine this to allow real and non-owner guests to log in on a virutal server's address.
 */
#define CLOSED_VIRTUAL_SERVER

/*
 * NO_DNS
 * Define this to skip DNS lookups.  If the remote host name is needed, the
 * daemon uses the IP numbers instead.  'deny !nameserved' will always be
 * true (denying access) if this patch is enabled.
 *
 * This option is intended soley for very busy FTP sites where the added
 * security of DNS lookups is overshadowed by the speed and resource penalties.
 *
 * Disabling DNS lookups removes all protections against spoofing, making
 * remote user authentication virtually useless.  This option should only be
 * used on anonymous FTP servers.
 *
 * If you're not *absolutely sure* you need this, don't enable it.
 */
#undef NO_DNS

/*
 * Some people don't like PASV and want to disable it.  Whatever.
 * PORT can be abused to attack other hosts.  Let's give the option to
 * disable one or the other.  We'll ignore DISABLE_PASV if you defined
 * DISABLE_PORT (hey, you gotta have at least one!).
 */
#undef DISABLE_PORT
#undef DISABLE_PASV

/*
 * Define this to suppress messages about PID locks causing the daemon to
 * sleep.  This should only be needed at busy sites.
 */
#undef NO_PID_SLEEP_MSGS

/*
 * Define this to require the remove end of a PASV connection to have the
 * same IP as the control connection.  This limits, but does not eliminate,
 * the risk of PASV port race stealing the connection.  It also is non-RFC
 * compliant, so it may cause problems for some client sites.
 */
#define FIGHT_PASV_PORT_RACE

/*
 * Define this to completely disable anonymous FTP access.
 */
#undef NO_ANONYMOUS_ACCESS
