DESTDIR=

BINDIR=		${DESTDIR}/usr/bin
BINOWN=		bin
BINGRP=		bin

SBINDIR=	${DESTDIR}/etc
SBINOWN=	bin
SBINGRP=	bin

MANDIR=		${DESTDIR}/usr/man
MANOWN=		bin
MANGRP=		bin

INSTALL=	./util/install

all:
	@ echo 'Use the "build" command (shell script) to make ftpd.'
	@ echo 'You can say "build help" for details on how it works.'

install: bin/ftpd bin/ftpcount bin/ftpshut
	@echo installing binaries.
	@if [ ! -e ${BINDIR} ]; then \
		${INSTALL} -o ${BINOWN} -g ${BINGRP} -m 755 -d ${BINDIR} ; \
	fi
	@if [ ! -e ${SBINDIR} ]; then \
		${INSTALL} -o ${SBINOWN} -g ${SBINGRP} -m 755 -d ${SBINDIR} ; \
	fi
	${INSTALL} -c -o ${SBINOWN} -g ${SBINGRP} -m 110 bin/ftpd           ${SBINDIR}/in.ftpd
	${INSTALL} -c -o ${BINOWN}  -g ${BINGRP}  -m 111 bin/ftpshut        ${BINDIR}/ftpshut
	${INSTALL} -c -o ${BINOWN}  -g ${BINGRP}  -m 111 bin/ftpcount       ${BINDIR}/ftpcount
	${INSTALL} -c -o ${BINOWN}  -g ${BINGRP}  -m 111 bin/ftpwho         ${BINDIR}/ftpwho
	@echo installing manpages.
	@if [ ! -e ${MANDIR}/man1 ]; then \
		${INSTALL} -o ${MANOWN} -g ${MANGRP} -m 755 -d ${MANDIR}/man1 ; \
	fi
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/ftpcount.1       ${MANDIR}/man1/ftpcount.1
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/ftpwho.1         ${MANDIR}/man1/ftpwho.1
	@if [ ! -e ${MANDIR}/man5 ]; then \
		${INSTALL} -o ${MANOWN} -g ${MANGRP} -m 755 -d ${MANDIR}/man5 ; \
	fi
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/ftpaccess.5      ${MANDIR}/man5/ftpaccess.5
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/ftpconversions.5 ${MANDIR}/man5/ftpconversions.5
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/ftphosts.5       ${MANDIR}/man5/ftphosts.5
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/xferlog.5        ${MANDIR}/man5/xferlog.5
	@if [ ! -e ${MANDIR}/man8 ]; then \
		${INSTALL} -o ${MANOWN} -g ${MANGRP} -m 755 -d ${MANDIR}/man8 ; \
	fi
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/ftpd.8           ${MANDIR}/man8/ftpd.8
	${INSTALL} -c -o ${MANOWN} -g ${MANGRP} -m 444 doc/ftpshut.8        ${MANDIR}/man8/ftpshut.8
