
/*
 * Contributed by Glenn Nielsen <glenn@more.net>
 * Mon, 18 Jan 1999 20:04:07 -0600
 */

#include "config.h"

/* $Id: restrict.c,v 1.2 1996/02/20 04:54:04 root Exp $ */

#include <sys/param.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#ifdef HAVE_GETCWD
extern char *getcwd();
#else
extern char *getwd(char *);
#endif

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

extern char *home;
extern int restricted_user;

/*
 * name is the function parameter
 * home is a global string containing the user's home directory
 *
 * rhome is the resolved home directory
 * rname is the resolved requested filename
 * curwd is the current working directory
 * path is name, possibly prepended by the current working directory
 */

int restrict_check (char *name) {

    char rhome[MAXPATHLEN+1],
	 rname[MAXPATHLEN+1],
	 path[MAXPATHLEN+1];

    /* we're not in restrict mode so all access is OK */
    if (restricted_user == FALSE) return 0;

    /* get resolved equivalent of user's home directory */
    fb_realpath (home, rhome);

    path[0] = '\0';

    /* a relative path is specified, so resolve it w.r.t. current working directory */
    if ((name)[0] != '/') {

	 char curwd[MAXPATHLEN+1];

	/* determine current working directory */
#ifdef HAVE_GETCWD
	if (getcwd(curwd,MAXPATHLEN) == (char *) NULL) {
#else
	if (getwd(curwd) == (char *) NULL) {
#endif
	    goto bad;
	} /* if */

	strcpy (path, curwd);
	strcat (path, "/");

    } /* if */

    if ((strlen(path) + strlen(name) + 2) > sizeof(path)) {
	goto bad;
    }

    strcat (path, name);
    strcat (path, "/");
    fb_realpath (path, rname);

    if (strncmp (rhome, rname, strlen (rhome))) {
	goto bad;
    } /* if */

    return 0;

bad:
    reply (550, "Permission denied on server.  You are restricted to your account.");
    return 1;

} /* restrict_check */

int restrict_list_check (char *name) {

    char *beg, *copy, *end;
    int flag;

    beg = name;

    while (*beg != '\0') {

	flag = 0;
	end = beg;
	while (*end && !isspace (*end)) ++end;
	if (!*end) flag = 1;
	if (!flag) *end = '\0';
	copy = strdup (beg);
	if (!flag) *end = ' ';

	if (!copy) {
	    reply (550, "Permission denied on server.  Out of memory.");
	    return 1;

	} /* if */

	if (restrict_check (copy)) {
	    free (copy);
	    return 1;
	}
	free (copy);
	beg = end;
	if (!flag) ++beg;

    } /* while */

    return 0;

} /* restrict_list_check */

/*
 * $Log: restrict.c,v $
 * Revision 1.2  1996/02/20 04:54:04  root
 * added #define to make gcc use HAVE_GETCWD
 *
 * Revision 1.1  1996/02/20 03:52:48  root
 * Initial revision
 *
 */

