#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <nss_dbdefs.h>
#include <stdio.h>
#include <string.h>
#include <sys/systeminfo.h>
#include "nss_wins.h"
#include "wins_resolve.h"
#include "nb_whats_your_name.h"
#include "includes.h"

/* #define DEBUG(l,m) (l <= DEBUGLEVEL) && printf m */

extern pstring scope;
extern pstring myhostname;
extern struct in_addr ipzero;
extern int DEBUGLEVEL;

static int _init_nmb(int useroot) {
  int ServerFD;

  DEBUG(4,("Calling TimeInit()\n"));
  TimeInit();
  DEBUG(4,("Calling charset_initialise()\n"));
  charset_initialise();
  DEBUG(4,("Calling get_myname()\n"));
  if (!get_myname(myhostname,NULL))
    return 0;
  DEBUG(4,("Calling load_interfaces()\n"));
  load_interfaces();
  DEBUG(4,("Opening socket\n"));
  ServerFD = open_socket_in( SOCK_DGRAM, (useroot ? 137 : 0), 3,
                             interpret_addr(lp_socket_address()) );
  if (ServerFD == -1)
    return 0;
  set_socket_options(ServerFD,"SO_BROADCAST");
  return ServerFD;
}

unsigned long wins_gethostbyname(wins_backend_ptr_t backend, char *name)
{
  struct in_addr server_addr;
  struct in_addr *ip_list;
  int ServerFD;
  int count;
  int bcast = 0;
  pstring looking_for_buf;
  pstring domainname;
  char *looking_for;

  DEBUG(4,("(De)canonicalizing the hostname\n"));
  sysinfo(SI_SRPC_DOMAIN,domainname,256);
  *looking_for_buf = '\0';
  looking_for = looking_for_buf + 1;
  strncpy(looking_for,name,strlen(name));
  looking_for[strlen(name)] = '\0';
  if (*domainname) {
    if (*(looking_for + strlen(looking_for) - 1) == '.')
      *(looking_for + strlen(looking_for) - 1) = '\0';
    if (!strcmp(domainname,
		(looking_for + strlen(looking_for) - strlen(domainname))) &&
	*(looking_for + strlen(looking_for) - strlen(domainname) - 1) == '.')
      *(looking_for + strlen(looking_for) - strlen(domainname) - 1) = '\0';
  }
  DEBUG(4,("Calling _init_nmb(0)\n"));
  ServerFD = _init_nmb(0);
  if (!ServerFD) {
    DEBUG(4,("Couldn't initialize.  Bummer.\n"));
    return 0;
  }
  if (backend->wins_server.S_un.S_addr) {
    DEBUG(4,("Setting for unicast\n"));
    server_addr = backend->wins_server;
  }
  else {
    DEBUG(4,("Setting for broadcast\n"));
    server_addr = *iface_bcast(ipzero);
    bcast = 1;
  }
  DEBUG(4,("Looking up %s\n",looking_for));
  ip_list = name_query(ServerFD,looking_for,0,bcast,1,server_addr,&count,NULL);
  close(ServerFD);
  if (count) {
    DEBUG(4,("Found it!\n"));
    DEBUG(4,("Returning %s\n",inet_ntoa(*ip_list)));
    return ip_list->S_un.S_addr;
  }
  DEBUG(4,("Couldn't find it\n"));
  return 0;
}
  
void wins_gethostbyaddr(wins_backend_ptr_t backend, char *host_addr)
{
  int ServerFD;
  char *name;

  ServerFD = _init_nmb(1);
  backend->host.h_name = NULL;
  if (!ServerFD) {
    DEBUG(3,("Couldn't initialize.  Bummer.\n"));
    return;
  }
  name = nb_whats_your_name(ServerFD,host_addr);
  close(ServerFD);
  if (name) {
    DEBUG(3,("Got %s\n",name));
  }
  else {
    DEBUG(3,("Didn't find anything\n"));
  }
  backend->host.h_name = name;
}
