/*
   Unix SMB/Netbios implementation.
   Version 0.1
   WINS server routines and daemon - version 3
   Copyright (C) Andrew Tridgell 1994-1996 Luke Leighton 1996
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   Revision History:

   14 jan 96: lkcl@pires.co.uk
   added multiple workgroup domain master support


   30 July 96: David.Chappell@mail.trincoll.edu
   Expanded multiple workgroup domain master browser support.

*/

#include "includes.h"

extern int DEBUGLEVEL;
extern pstring debugf;

extern int ClientNMB[];


/****************************************************************************
  forward request packets to nmbd

  IMPORTANT: send proxied packets via ClientNMB because if we don't, and
  nmbd is not running, winsd hangs with a read error on its socket because
  it can't get the sent packet out of its queue (on linux 1.2.13 anyway...)
  ****************************************************************************/
void proxy_forward_packet(time_t time_now, struct packet_struct *p)
{
	int idx = iface_idx(p->ip);
	p->packet.nmb.header.name_trn_id = save_response_record(time_now,
                        p->port,p->ip,
						p->packet.nmb.header.name_trn_id,
						time_now+4,True);

    p->ip.s_addr = inet_addr("127.0.0.1");
	p->fd = ClientNMB[idx];
	p->timestamp = time_now;
	p->port = NMB_PORT;
	p->packet_type = NMB_PACKET;

	/* forward the packet. receipt of this packet, by nmbd, on 127.0.0.1
       will alert nmbd to check the response records and look up the
       real location the response needs to go to, _not_ back to winsd
     */

	DEBUG(4,("forwarding packet...\n"));

	send_packet(p);
}

/****************************************************************************
  proxy unexpected response packets 

  IMPORTANT: send proxied packets via ClientNMB because if we don't, and
  nmbd is not running, winsd hangs with a read error on its socket because
  it can't get the sent packet out of its queue (on linux 1.2.13 anyway...)
  ****************************************************************************/
void proxy_nmb_packet(time_t time_now, struct packet_struct *p)
{
	int idx = iface_idx(p->ip);

	int port;
	struct in_addr ip;
	uint16 id;

	if (!confirm_response_record(p->timestamp,p->packet.nmb.header.name_trn_id,
				&port, &ip, &id, False))
	{
		return;
	}

	p->packet.nmb.header.name_trn_id = id;

    p->ip.s_addr = inet_addr("127.0.0.1");
	p->fd = ClientNMB[idx];
	p->timestamp = time_now;
	p->port = port;
	p->packet_type = NMB_PACKET;

	/* proxy-send the packet. and all because of microsoft sending packets
       back to NMB_PORT _not_ to the requestor's port.
     */

	DEBUG(4,("proxied packet being sent...\n"));

	debug_nmb_packet(p);

	send_packet(p);
}

