/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_efs.h"
#include "autoconf/librpc/gen_ndr/ndr_efs_c.h"

/* efs - client functions generated by pidl */

struct dcerpc_EfsRpcOpenFileRaw_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcOpenFileRaw_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcOpenFileRaw_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EfsRpcOpenFileRaw *r)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcOpenFileRaw_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcOpenFileRaw_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCOPENFILERAW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcOpenFileRaw_r_done, req);

	return req;
}

static void dcerpc_EfsRpcOpenFileRaw_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcOpenFileRaw_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcOpenFileRaw_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EfsRpcOpenFileRaw_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcOpenFileRaw_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EfsRpcOpenFileRaw *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCOPENFILERAW, mem_ctx, r);

	return status;
}

struct dcerpc_EfsRpcOpenFileRaw_state {
	struct EfsRpcOpenFileRaw orig;
	struct EfsRpcOpenFileRaw tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcOpenFileRaw_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcOpenFileRaw_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_pvContext /* [out] [ref] */,
						 const char *_FileName /* [in] [charset(UTF16)] */,
						 uint32_t _Flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcOpenFileRaw_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcOpenFileRaw_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.FileName = _FileName;
	state->orig.in.Flags = _Flags;

	/* Out parameters */
	state->orig.out.pvContext = _pvContext;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EfsRpcOpenFileRaw_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EfsRpcOpenFileRaw_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcOpenFileRaw_done, req);
	return req;
}

static void dcerpc_EfsRpcOpenFileRaw_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EfsRpcOpenFileRaw_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcOpenFileRaw_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EfsRpcOpenFileRaw_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pvContext = *state->tmp.out.pvContext;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcOpenFileRaw_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_EfsRpcOpenFileRaw_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcOpenFileRaw_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcOpenFileRaw(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_pvContext /* [out] [ref] */,
				  const char *_FileName /* [in] [charset(UTF16)] */,
				  uint32_t _Flags /* [in]  */,
				  WERROR *result)
{
	struct EfsRpcOpenFileRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = _FileName;
	r.in.Flags = _Flags;

	/* Out parameters */
	r.out.pvContext = _pvContext;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EfsRpcOpenFileRaw_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pvContext = *r.out.pvContext;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EfsRpcCloseRaw_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcCloseRaw_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcCloseRaw_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EfsRpcCloseRaw *r)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcCloseRaw_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcCloseRaw_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCCLOSERAW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcCloseRaw_r_done, req);

	return req;
}

static void dcerpc_EfsRpcCloseRaw_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcCloseRaw_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcCloseRaw_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EfsRpcCloseRaw_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcCloseRaw_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EfsRpcCloseRaw *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCCLOSERAW, mem_ctx, r);

	return status;
}

struct dcerpc_EfsRpcCloseRaw_state {
	struct EfsRpcCloseRaw orig;
	struct EfsRpcCloseRaw tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcCloseRaw_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcCloseRaw_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_pvContext /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcCloseRaw_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcCloseRaw_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pvContext = _pvContext;

	/* Out parameters */
	state->orig.out.pvContext = _pvContext;

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EfsRpcCloseRaw_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EfsRpcCloseRaw_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcCloseRaw_done, req);
	return req;
}

static void dcerpc_EfsRpcCloseRaw_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EfsRpcCloseRaw_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcCloseRaw_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EfsRpcCloseRaw_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pvContext = *state->tmp.out.pvContext;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcCloseRaw_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcCloseRaw_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcCloseRaw_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcCloseRaw(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_pvContext /* [in,out] [ref] */)
{
	struct EfsRpcCloseRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.pvContext = _pvContext;

	/* Out parameters */
	r.out.pvContext = _pvContext;

	status = dcerpc_EfsRpcCloseRaw_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pvContext = *r.out.pvContext;

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_EfsRpcEncryptFileSrv_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcEncryptFileSrv_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcEncryptFileSrv_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EfsRpcEncryptFileSrv *r)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcEncryptFileSrv_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcEncryptFileSrv_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCENCRYPTFILESRV, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcEncryptFileSrv_r_done, req);

	return req;
}

static void dcerpc_EfsRpcEncryptFileSrv_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcEncryptFileSrv_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcEncryptFileSrv_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EfsRpcEncryptFileSrv_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcEncryptFileSrv_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EfsRpcEncryptFileSrv *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCENCRYPTFILESRV, mem_ctx, r);

	return status;
}

struct dcerpc_EfsRpcEncryptFileSrv_state {
	struct EfsRpcEncryptFileSrv orig;
	struct EfsRpcEncryptFileSrv tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcEncryptFileSrv_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcEncryptFileSrv_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_Filename /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcEncryptFileSrv_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcEncryptFileSrv_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.Filename = _Filename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EfsRpcEncryptFileSrv_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcEncryptFileSrv_done, req);
	return req;
}

static void dcerpc_EfsRpcEncryptFileSrv_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EfsRpcEncryptFileSrv_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcEncryptFileSrv_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EfsRpcEncryptFileSrv_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcEncryptFileSrv_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_EfsRpcEncryptFileSrv_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcEncryptFileSrv_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcEncryptFileSrv(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_Filename /* [in] [charset(UTF16)] */,
				     WERROR *result)
{
	struct EfsRpcEncryptFileSrv r;
	NTSTATUS status;

	/* In parameters */
	r.in.Filename = _Filename;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EfsRpcEncryptFileSrv_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EfsRpcDecryptFileSrv_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcDecryptFileSrv_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcDecryptFileSrv_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EfsRpcDecryptFileSrv *r)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcDecryptFileSrv_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcDecryptFileSrv_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCDECRYPTFILESRV, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcDecryptFileSrv_r_done, req);

	return req;
}

static void dcerpc_EfsRpcDecryptFileSrv_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcDecryptFileSrv_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcDecryptFileSrv_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EfsRpcDecryptFileSrv_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcDecryptFileSrv_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EfsRpcDecryptFileSrv *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCDECRYPTFILESRV, mem_ctx, r);

	return status;
}

struct dcerpc_EfsRpcDecryptFileSrv_state {
	struct EfsRpcDecryptFileSrv orig;
	struct EfsRpcDecryptFileSrv tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcDecryptFileSrv_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcDecryptFileSrv_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_FileName /* [in] [charset(UTF16)] */,
						    uint32_t _Reserved /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcDecryptFileSrv_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcDecryptFileSrv_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.FileName = _FileName;
	state->orig.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EfsRpcDecryptFileSrv_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcDecryptFileSrv_done, req);
	return req;
}

static void dcerpc_EfsRpcDecryptFileSrv_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EfsRpcDecryptFileSrv_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcDecryptFileSrv_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EfsRpcDecryptFileSrv_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcDecryptFileSrv_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_EfsRpcDecryptFileSrv_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcDecryptFileSrv_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcDecryptFileSrv(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_FileName /* [in] [charset(UTF16)] */,
				     uint32_t _Reserved /* [in]  */,
				     WERROR *result)
{
	struct EfsRpcDecryptFileSrv r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = _FileName;
	r.in.Reserved = _Reserved;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EfsRpcDecryptFileSrv_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EfsRpcQueryUsersOnFile_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcQueryUsersOnFile_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcQueryUsersOnFile_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EfsRpcQueryUsersOnFile *r)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcQueryUsersOnFile_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcQueryUsersOnFile_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCQUERYUSERSONFILE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcQueryUsersOnFile_r_done, req);

	return req;
}

static void dcerpc_EfsRpcQueryUsersOnFile_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcQueryUsersOnFile_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcQueryUsersOnFile_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EfsRpcQueryUsersOnFile_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcQueryUsersOnFile_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EfsRpcQueryUsersOnFile *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCQUERYUSERSONFILE, mem_ctx, r);

	return status;
}

struct dcerpc_EfsRpcQueryUsersOnFile_state {
	struct EfsRpcQueryUsersOnFile orig;
	struct EfsRpcQueryUsersOnFile tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcQueryUsersOnFile_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcQueryUsersOnFile_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      const char *_FileName /* [in] [charset(UTF16)] */,
						      struct ENCRYPTION_CERTIFICATE_HASH_LIST **_pUsers /* [out] [ref,unique] */)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcQueryUsersOnFile_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcQueryUsersOnFile_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.FileName = _FileName;

	/* Out parameters */
	state->orig.out.pUsers = _pUsers;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EfsRpcQueryUsersOnFile_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EfsRpcQueryUsersOnFile_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcQueryUsersOnFile_done, req);
	return req;
}

static void dcerpc_EfsRpcQueryUsersOnFile_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EfsRpcQueryUsersOnFile_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcQueryUsersOnFile_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EfsRpcQueryUsersOnFile_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pUsers = *state->tmp.out.pUsers;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcQueryUsersOnFile_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_EfsRpcQueryUsersOnFile_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcQueryUsersOnFile_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcQueryUsersOnFile(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       const char *_FileName /* [in] [charset(UTF16)] */,
				       struct ENCRYPTION_CERTIFICATE_HASH_LIST **_pUsers /* [out] [ref,unique] */,
				       WERROR *result)
{
	struct EfsRpcQueryUsersOnFile r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = _FileName;

	/* Out parameters */
	r.out.pUsers = _pUsers;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EfsRpcQueryUsersOnFile_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pUsers = *r.out.pUsers;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EfsRpcQueryRecoveryAgents_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcQueryRecoveryAgents_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcQueryRecoveryAgents_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EfsRpcQueryRecoveryAgents *r)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcQueryRecoveryAgents_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcQueryRecoveryAgents_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCQUERYRECOVERYAGENTS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcQueryRecoveryAgents_r_done, req);

	return req;
}

static void dcerpc_EfsRpcQueryRecoveryAgents_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcQueryRecoveryAgents_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcQueryRecoveryAgents_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EfsRpcQueryRecoveryAgents_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcQueryRecoveryAgents_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EfsRpcQueryRecoveryAgents *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCQUERYRECOVERYAGENTS, mem_ctx, r);

	return status;
}

struct dcerpc_EfsRpcQueryRecoveryAgents_state {
	struct EfsRpcQueryRecoveryAgents orig;
	struct EfsRpcQueryRecoveryAgents tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcQueryRecoveryAgents_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcQueryRecoveryAgents_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_FileName /* [in] [charset(UTF16)] */,
							 struct ENCRYPTION_CERTIFICATE_HASH_LIST **_pRecoveryAgents /* [out] [ref,unique] */)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcQueryRecoveryAgents_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcQueryRecoveryAgents_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.FileName = _FileName;

	/* Out parameters */
	state->orig.out.pRecoveryAgents = _pRecoveryAgents;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_EfsRpcQueryRecoveryAgents_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EfsRpcQueryRecoveryAgents_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcQueryRecoveryAgents_done, req);
	return req;
}

static void dcerpc_EfsRpcQueryRecoveryAgents_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EfsRpcQueryRecoveryAgents_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcQueryRecoveryAgents_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EfsRpcQueryRecoveryAgents_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pRecoveryAgents = *state->tmp.out.pRecoveryAgents;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcQueryRecoveryAgents_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_EfsRpcQueryRecoveryAgents_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcQueryRecoveryAgents_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcQueryRecoveryAgents(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_FileName /* [in] [charset(UTF16)] */,
					  struct ENCRYPTION_CERTIFICATE_HASH_LIST **_pRecoveryAgents /* [out] [ref,unique] */,
					  WERROR *result)
{
	struct EfsRpcQueryRecoveryAgents r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = _FileName;

	/* Out parameters */
	r.out.pRecoveryAgents = _pRecoveryAgents;

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EfsRpcQueryRecoveryAgents_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pRecoveryAgents = *r.out.pRecoveryAgents;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_EfsRpcSetFileEncryptionKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcSetFileEncryptionKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcSetFileEncryptionKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct EfsRpcSetFileEncryptionKey *r)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcSetFileEncryptionKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcSetFileEncryptionKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCSETFILEENCRYPTIONKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcSetFileEncryptionKey_r_done, req);

	return req;
}

static void dcerpc_EfsRpcSetFileEncryptionKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcSetFileEncryptionKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_EfsRpcSetFileEncryptionKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_EfsRpcSetFileEncryptionKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcSetFileEncryptionKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct EfsRpcSetFileEncryptionKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_efs,
			NDR_EFSRPCSETFILEENCRYPTIONKEY, mem_ctx, r);

	return status;
}

struct dcerpc_EfsRpcSetFileEncryptionKey_state {
	struct EfsRpcSetFileEncryptionKey orig;
	struct EfsRpcSetFileEncryptionKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_EfsRpcSetFileEncryptionKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_EfsRpcSetFileEncryptionKey_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct ENCRYPTION_CERTIFICATE *_pEncryptionCertificate /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_EfsRpcSetFileEncryptionKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_EfsRpcSetFileEncryptionKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pEncryptionCertificate = _pEncryptionCertificate;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_EfsRpcSetFileEncryptionKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_EfsRpcSetFileEncryptionKey_done, req);
	return req;
}

static void dcerpc_EfsRpcSetFileEncryptionKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_EfsRpcSetFileEncryptionKey_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcSetFileEncryptionKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_EfsRpcSetFileEncryptionKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_EfsRpcSetFileEncryptionKey_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_EfsRpcSetFileEncryptionKey_state *state = tevent_req_data(
		req, struct dcerpc_EfsRpcSetFileEncryptionKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_EfsRpcSetFileEncryptionKey(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct ENCRYPTION_CERTIFICATE *_pEncryptionCertificate /* [in] [unique] */,
					   WERROR *result)
{
	struct EfsRpcSetFileEncryptionKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.pEncryptionCertificate = _pEncryptionCertificate;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(r.out.result);

	status = dcerpc_EfsRpcSetFileEncryptionKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

