/*
 * Copyright 1991 Klaus Zitzmann, 1993-1996 Johannes Sixt
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation for any purpose other than its commercial exploitation
 * is hereby granted without fee, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation. The authors
 * make no representations about the suitability of this software for
 * any purpose. It is provided "as is" without express or implied warranty.
 *
 * THE AUTHORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Authors: Klaus Zitzmann <zitzmann@infko.uni-koblenz.de>
 *          Johannes Sixt <Johannes.Sixt@telecom.at>
 */


#ifndef _GRAPHICS_H_
#define _GRAPHICS_H_

typedef enum {
	graphLine, graphVector, graphCircle, graphDisc, graphOval,
	graphBezier, graphFramed, graphDashed, graphFilled, graphText,
	graphCopy, graphErasePick, graphEditPick, graphZoom
} GraphMode;

#define GRAPH_MODE_MAX	((int) graphZoom)
#define MAX_TEXT_LEN	127

/* prototypes */
void GraphicsInit(XtAppContext context, Widget parent, Widget coord,
		XFontStruct *ruler_font, Pixel foreground, Pixel background);
void CommandCB(Widget w, XtPointer client_data, XtPointer call_data);
void AbortGraphCB(Widget w, XtPointer client_data, XtPointer call_data);
void ToggleRuler(Widget w, XtPointer client_data, XtPointer call_data);
void ToggleRaster(Widget w, XtPointer client_data, XtPointer call_data);
void EditTextCB(Widget w, XtPointer client_data, XtPointer call_data);

extern Boolean cross, ruler;
extern GraphMode graphMode;		/* what currently is drawn */

#endif /* _GRAPHICS_H_ */
